/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;

public final class PoolUtils {
    private static final String MSG_FACTOR_NEGATIVE = "factor must be positive.";
    private static final String MSG_MIN_IDLE = "minIdle must be non-negative.";
    static final String MSG_NULL_KEY = "key must not be null.";
    private static final String MSG_NULL_KEYED_POOL = "keyedPool must not be null.";
    static final String MSG_NULL_KEYS = "keys must not be null.";
    private static final String MSG_NULL_POOL = "pool must not be null.";

    public static <K, V> Map<K, TimerTask> checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n2, long l2) {
        if (collection == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYS);
        }
        HashMap<K, TimerTask> hashMap = new HashMap<K, TimerTask>(collection.size());
        for (K k2 : collection) {
            TimerTask timerTask = PoolUtils.checkMinIdle(keyedObjectPool, k2, n2, l2);
            hashMap.put(k2, timerTask);
        }
        return hashMap;
    }

    public static <K, V> TimerTask checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, K k2, int n2, long l2) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (k2 == null) {
            throw new IllegalArgumentException(MSG_NULL_KEY);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(MSG_MIN_IDLE);
        }
        KeyedObjectPoolMinIdleTimerTask<K, V> keyedObjectPoolMinIdleTimerTask = new KeyedObjectPoolMinIdleTimerTask<K, V>(keyedObjectPool, k2, n2);
        PoolUtils.getMinIdleTimer().schedule(keyedObjectPoolMinIdleTimerTask, 0L, l2);
        return keyedObjectPoolMinIdleTimerTask;
    }

    public static <T> TimerTask checkMinIdle(ObjectPool<T> objectPool, int n2, long l2) {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(MSG_MIN_IDLE);
        }
        ObjectPoolMinIdleTimerTask<T> objectPoolMinIdleTimerTask = new ObjectPoolMinIdleTimerTask<T>(objectPool, n2);
        PoolUtils.getMinIdleTimer().schedule(objectPoolMinIdleTimerTask, 0L, l2);
        return objectPoolMinIdleTimerTask;
    }

    public static void checkRethrow(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool) {
        return PoolUtils.erodingPool(keyedObjectPool, 1.0f);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f2) {
        return PoolUtils.erodingPool(keyedObjectPool, f2, false);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f2, boolean bl) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(MSG_FACTOR_NEGATIVE);
        }
        if (bl) {
            return new ErodingPerKeyKeyedObjectPool<K, V>(keyedObjectPool, f2);
        }
        return new ErodingKeyedObjectPool<K, V>(keyedObjectPool, f2);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool) {
        return PoolUtils.erodingPool(objectPool, 1.0f);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool, float f2) {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(MSG_FACTOR_NEGATIVE);
        }
        return new ErodingObjectPool<T>(objectPool, f2);
    }

    private static Timer getMinIdleTimer() {
        return TimerHolder.MIN_IDLE_TIMER;
    }

    @Deprecated
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n2) {
        if (collection == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYS);
        }
        keyedObjectPool.addObjects(collection, n2);
    }

    @Deprecated
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, K k2, int n2) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        keyedObjectPool.addObjects(k2, n2);
    }

    @Deprecated
    public static <T> void prefill(ObjectPool<T> objectPool, int n2) {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        objectPool.addObjects(n2);
    }

    public static <K, V> KeyedPooledObjectFactory<K, V> synchronizedKeyedPooledFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) {
        return new SynchronizedKeyedPooledObjectFactory<K, V>(keyedPooledObjectFactory);
    }

    public static <K, V> KeyedObjectPool<K, V> synchronizedPool(KeyedObjectPool<K, V> keyedObjectPool) {
        return new SynchronizedKeyedObjectPool<K, V>(keyedObjectPool);
    }

    public static <T> ObjectPool<T> synchronizedPool(ObjectPool<T> objectPool) {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        return new SynchronizedObjectPool<T>(objectPool);
    }

    public static <T> PooledObjectFactory<T> synchronizedPooledFactory(PooledObjectFactory<T> pooledObjectFactory) {
        return new SynchronizedPooledObjectFactory<T>(pooledObjectFactory);
    }

    static class TimerHolder {
        static final Timer MIN_IDLE_TIMER = new Timer(true);

        TimerHolder() {
        }
    }

    private static final class SynchronizedPooledObjectFactory<T>
    implements PooledObjectFactory<T> {
        private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        private final PooledObjectFactory<T> factory;

        SynchronizedPooledObjectFactory(PooledObjectFactory<T> pooledObjectFactory) {
            if (pooledObjectFactory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = pooledObjectFactory;
        }

        @Override
        public void activateObject(PooledObject<T> pooledObject) {
            this.writeLock.lock();
            try {
                this.factory.activateObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(PooledObject<T> pooledObject) {
            this.writeLock.lock();
            try {
                this.factory.destroyObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public PooledObject<T> makeObject() {
            this.writeLock.lock();
            try {
                PooledObject<T> pooledObject = this.factory.makeObject();
                return pooledObject;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void passivateObject(PooledObject<T> pooledObject) {
            this.writeLock.lock();
            try {
                this.factory.passivateObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedPoolableObjectFactory");
            stringBuilder.append("{factory=").append(this.factory);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public boolean validateObject(PooledObject<T> pooledObject) {
            this.writeLock.lock();
            try {
                boolean bl = this.factory.validateObject(pooledObject);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static final class SynchronizedObjectPool<T>
    implements ObjectPool<T> {
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final ObjectPool<T> pool;

        SynchronizedObjectPool(ObjectPool<T> objectPool) {
            if (objectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_POOL);
            }
            this.pool = objectPool;
        }

        @Override
        public void addObject() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.addObject();
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public T borrowObject() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                T t2 = this.pool.borrowObject();
                return t2;
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void clear() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.clear();
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void close() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.close();
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public int getNumActive() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n2 = this.pool.getNumActive();
                return n2;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        public int getNumIdle() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n2 = this.pool.getNumIdle();
                return n2;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(T t2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.invalidateObject(t2);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(T t2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.returnObject(t2);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedObjectPool");
            stringBuilder.append("{pool=").append(this.pool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class SynchronizedKeyedPooledObjectFactory<K, V>
    implements KeyedPooledObjectFactory<K, V> {
        private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        private final KeyedPooledObjectFactory<K, V> keyedFactory;

        SynchronizedKeyedPooledObjectFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) {
            if (keyedPooledObjectFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            this.keyedFactory = keyedPooledObjectFactory;
        }

        @Override
        public void activateObject(K k2, PooledObject<V> pooledObject) {
            this.writeLock.lock();
            try {
                this.keyedFactory.activateObject(k2, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(K k2, PooledObject<V> pooledObject) {
            this.writeLock.lock();
            try {
                this.keyedFactory.destroyObject(k2, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public PooledObject<V> makeObject(K k2) {
            this.writeLock.lock();
            try {
                PooledObject<V> pooledObject = this.keyedFactory.makeObject(k2);
                return pooledObject;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void passivateObject(K k2, PooledObject<V> pooledObject) {
            this.writeLock.lock();
            try {
                this.keyedFactory.passivateObject(k2, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedKeyedPoolableObjectFactory");
            stringBuilder.append("{keyedFactory=").append(this.keyedFactory);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(K k2, PooledObject<V> pooledObject) {
            this.writeLock.lock();
            try {
                boolean bl = this.keyedFactory.validateObject(k2, pooledObject);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static final class SynchronizedKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final KeyedObjectPool<K, V> keyedPool;

        SynchronizedKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool) {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
        }

        @Override
        public void addObject(K k2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.addObject(k2);
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V borrowObject(K k2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                V v2 = this.keyedPool.borrowObject(k2);
                return v2;
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void clear() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.clear();
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void clear(K k2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.clear(k2);
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void close() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public int getNumActive() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n2 = this.keyedPool.getNumActive();
                return n2;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive(K k2) {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n2 = this.keyedPool.getNumActive(k2);
                return n2;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        public int getNumIdle() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n2 = this.keyedPool.getNumIdle();
                return n2;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle(K k2) {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n2 = this.keyedPool.getNumIdle(k2);
                return n2;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(K k2, V v2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.invalidateObject(k2, v2);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(K k2, V v2) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.returnObject(k2, v2);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedKeyedObjectPool");
            stringBuilder.append("{keyedPool=").append(this.keyedPool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class ObjectPoolMinIdleTimerTask<T>
    extends TimerTask {
        private final int minIdle;
        private final ObjectPool<T> pool;

        ObjectPoolMinIdleTimerTask(ObjectPool<T> objectPool, int n2) {
            if (objectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_POOL);
            }
            this.pool = objectPool;
            this.minIdle = n2;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.pool.getNumIdle() < this.minIdle) {
                    this.pool.addObject();
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ObjectPoolMinIdleTimerTask");
            stringBuilder.append("{minIdle=").append(this.minIdle);
            stringBuilder.append(", pool=").append(this.pool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class KeyedObjectPoolMinIdleTimerTask<K, V>
    extends TimerTask {
        private final int minIdle;
        private final K key;
        private final KeyedObjectPool<K, V> keyedPool;

        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool<K, V> keyedObjectPool, K k2, int n2) {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
            this.key = k2;
            this.minIdle = n2;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.keyedPool.getNumIdle(this.key) < this.minIdle) {
                    this.keyedPool.addObject(this.key);
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("KeyedObjectPoolMinIdleTimerTask");
            stringBuilder.append("{minIdle=").append(this.minIdle);
            stringBuilder.append(", key=").append(this.key);
            stringBuilder.append(", keyedPool=").append(this.keyedPool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class ErodingPerKeyKeyedObjectPool<K, V>
    extends ErodingKeyedObjectPool<K, V> {
        private final float factor;
        private final Map<K, ErodingFactor> factors = Collections.synchronizedMap(new HashMap());

        public ErodingPerKeyKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f2) {
            super(keyedObjectPool, null);
            this.factor = f2;
        }

        @Override
        protected ErodingFactor getErodingFactor(K k2) {
            ErodingFactor erodingFactor = this.factors.get(k2);
            if (erodingFactor == null) {
                erodingFactor = new ErodingFactor(this.factor);
                this.factors.put(k2, erodingFactor);
            }
            return erodingFactor;
        }

        @Override
        public String toString() {
            return "ErodingPerKeyKeyedObjectPool{factor=" + this.factor + ", keyedPool=" + this.getKeyedPool() + '}';
        }
    }

    private static class ErodingObjectPool<T>
    implements ObjectPool<T> {
        private final ObjectPool<T> pool;
        private final ErodingFactor factor;

        public ErodingObjectPool(ObjectPool<T> objectPool, float f2) {
            this.pool = objectPool;
            this.factor = new ErodingFactor(f2);
        }

        @Override
        public void addObject() {
            this.pool.addObject();
        }

        @Override
        public T borrowObject() {
            return this.pool.borrowObject();
        }

        @Override
        public void clear() {
            this.pool.clear();
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int getNumActive() {
            return this.pool.getNumActive();
        }

        @Override
        public int getNumIdle() {
            return this.pool.getNumIdle();
        }

        @Override
        public void invalidateObject(T t2) {
            try {
                this.pool.invalidateObject(t2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(T t2) {
            boolean bl = false;
            long l2 = System.currentTimeMillis();
            ObjectPool<T> objectPool = this.pool;
            synchronized (objectPool) {
                if (this.factor.getNextShrink() < l2) {
                    int n2 = this.pool.getNumIdle();
                    if (n2 > 0) {
                        bl = true;
                    }
                    this.factor.update(l2, n2);
                }
            }
            try {
                if (bl) {
                    this.pool.invalidateObject(t2);
                } else {
                    this.pool.returnObject(t2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "ErodingObjectPool{factor=" + this.factor + ", pool=" + this.pool + '}';
        }
    }

    private static class ErodingKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final KeyedObjectPool<K, V> keyedPool;
        private final ErodingFactor erodingFactor;

        protected ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, ErodingFactor erodingFactor) {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
            this.erodingFactor = erodingFactor;
        }

        public ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f2) {
            this(keyedObjectPool, new ErodingFactor(f2));
        }

        @Override
        public void addObject(K k2) {
            this.keyedPool.addObject(k2);
        }

        @Override
        public V borrowObject(K k2) {
            return this.keyedPool.borrowObject(k2);
        }

        @Override
        public void clear() {
            this.keyedPool.clear();
        }

        @Override
        public void clear(K k2) {
            this.keyedPool.clear(k2);
        }

        @Override
        public void close() {
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected ErodingFactor getErodingFactor(K k2) {
            return this.erodingFactor;
        }

        protected KeyedObjectPool<K, V> getKeyedPool() {
            return this.keyedPool;
        }

        @Override
        public int getNumActive() {
            return this.keyedPool.getNumActive();
        }

        @Override
        public int getNumActive(K k2) {
            return this.keyedPool.getNumActive(k2);
        }

        @Override
        public int getNumIdle() {
            return this.keyedPool.getNumIdle();
        }

        @Override
        public int getNumIdle(K k2) {
            return this.keyedPool.getNumIdle(k2);
        }

        @Override
        public void invalidateObject(K k2, V v2) {
            try {
                this.keyedPool.invalidateObject(k2, v2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(K k2, V v2) {
            boolean bl = false;
            long l2 = System.currentTimeMillis();
            ErodingFactor erodingFactor = this.getErodingFactor(k2);
            KeyedObjectPool<K, V> keyedObjectPool = this.keyedPool;
            synchronized (keyedObjectPool) {
                if (erodingFactor.getNextShrink() < l2) {
                    int n2 = this.getNumIdle(k2);
                    if (n2 > 0) {
                        bl = true;
                    }
                    erodingFactor.update(l2, n2);
                }
            }
            try {
                if (bl) {
                    this.keyedPool.invalidateObject(k2, v2);
                } else {
                    this.keyedPool.returnObject(k2, v2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "ErodingKeyedObjectPool{factor=" + this.erodingFactor + ", keyedPool=" + this.keyedPool + '}';
        }
    }

    private static final class ErodingFactor {
        private final float factor;
        private volatile transient long nextShrinkMillis;
        private volatile transient int idleHighWaterMark;

        public ErodingFactor(float f2) {
            this.factor = f2;
            this.nextShrinkMillis = System.currentTimeMillis() + (long)(900000.0f * f2);
            this.idleHighWaterMark = 1;
        }

        public long getNextShrink() {
            return this.nextShrinkMillis;
        }

        public String toString() {
            return "ErodingFactor{factor=" + this.factor + ", idleHighWaterMark=" + this.idleHighWaterMark + '}';
        }

        public void update(long l2, int n2) {
            int n3 = Math.max(0, n2);
            this.idleHighWaterMark = Math.max(n3, this.idleHighWaterMark);
            float f2 = 15.0f;
            float f3 = 15.0f + -14.0f / (float)this.idleHighWaterMark * (float)n3;
            this.nextShrinkMillis = l2 + (long)(f3 * 60000.0f * this.factor);
        }
    }
}

