/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.pool2.DestroyMode;

public interface KeyedObjectPool<K, V>
extends Closeable {
    public void addObject(K var1);

    default public void addObjects(Collection<K> collection, int n2) {
        if (collection == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        Iterator<K> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addObjects(iterator.next(), n2);
        }
    }

    default public void addObjects(K k2, int n2) {
        if (k2 == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addObject(k2);
        }
    }

    public V borrowObject(K var1);

    public void clear();

    public void clear(K var1);

    @Override
    public void close();

    public int getNumActive();

    public int getNumActive(K var1);

    public int getNumIdle();

    public int getNumIdle(K var1);

    public void invalidateObject(K var1, V var2);

    default public void invalidateObject(K k2, V v2, DestroyMode destroyMode) {
        this.invalidateObject(k2, v2);
    }

    public void returnObject(K var1, V var2);
}

