/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.universalScheduler.foliaScheduler;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import me.ulrich.clans.library.universalScheduler.foliaScheduler.FoliaScheduledTask;
import me.ulrich.clans.library.universalScheduler.scheduling.schedulers.TaskScheduler;
import me.ulrich.clans.library.universalScheduler.scheduling.tasks.MyScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements TaskScheduler {
    final Plugin plugin;
    private final RegionScheduler regionScheduler = Bukkit.getServer().getRegionScheduler();
    private final GlobalRegionScheduler globalRegionScheduler = Bukkit.getServer().getGlobalRegionScheduler();
    private final AsyncScheduler asyncScheduler = Bukkit.getServer().getAsyncScheduler();

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isGlobalThread() {
        return Bukkit.getServer().isGlobalTickThread();
    }

    @Override
    public boolean isTickThread() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    public boolean isEntityThread(Entity entity) {
        return Bukkit.getServer().isOwnedByCurrentRegion(entity);
    }

    @Override
    public boolean isRegionThread(Location location) {
        return Bukkit.getServer().isOwnedByCurrentRegion(location);
    }

    @Override
    public MyScheduledTask runTask(Runnable runnable) {
        return new FoliaScheduledTask(this.globalRegionScheduler.run(this.plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLater(Runnable runnable, long l2) {
        if (l2 <= 0L) {
            return this.runTask(runnable);
        }
        return new FoliaScheduledTask(this.globalRegionScheduler.runDelayed(this.plugin, scheduledTask -> runnable.run(), l2));
    }

    @Override
    public MyScheduledTask runTaskTimer(Runnable runnable, long l2, long l3) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), l2, l3));
    }

    @Override
    public MyScheduledTask runTask(Plugin plugin, Runnable runnable) {
        return new FoliaScheduledTask(this.globalRegionScheduler.run(plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLater(Plugin plugin, Runnable runnable, long l2) {
        if (l2 <= 0L) {
            return this.runTask(plugin, runnable);
        }
        return new FoliaScheduledTask(this.globalRegionScheduler.runDelayed(plugin, scheduledTask -> runnable.run(), l2));
    }

    @Override
    public MyScheduledTask runTaskTimer(Plugin plugin, Runnable runnable, long l2, long l3) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(this.globalRegionScheduler.runAtFixedRate(plugin, scheduledTask -> runnable.run(), l2, l3));
    }

    @Override
    public MyScheduledTask runTask(Location location, Runnable runnable) {
        return new FoliaScheduledTask(this.regionScheduler.run(this.plugin, location, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLater(Location location, Runnable runnable, long l2) {
        if (l2 <= 0L) {
            return this.runTask(runnable);
        }
        return new FoliaScheduledTask(this.regionScheduler.runDelayed(this.plugin, location, scheduledTask -> runnable.run(), l2));
    }

    @Override
    public MyScheduledTask runTaskTimer(Location location, Runnable runnable, long l2, long l3) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(this.regionScheduler.runAtFixedRate(this.plugin, location, scheduledTask -> runnable.run(), l2, l3));
    }

    @Override
    public MyScheduledTask runTask(Entity entity, Runnable runnable) {
        return new FoliaScheduledTask(entity.getScheduler().run(this.plugin, scheduledTask -> runnable.run(), null));
    }

    @Override
    public MyScheduledTask runTaskLater(Entity entity, Runnable runnable, long l2) {
        if (l2 <= 0L) {
            return this.runTask(entity, runnable);
        }
        return new FoliaScheduledTask(entity.getScheduler().runDelayed(this.plugin, scheduledTask -> runnable.run(), null, l2));
    }

    @Override
    public MyScheduledTask runTaskTimer(Entity entity, Runnable runnable, long l2, long l3) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(entity.getScheduler().runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), null, l2, l3));
    }

    @Override
    public MyScheduledTask runTaskAsynchronously(Runnable runnable) {
        return new FoliaScheduledTask(this.asyncScheduler.runNow(this.plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLaterAsynchronously(Runnable runnable, long l2) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(this.asyncScheduler.runDelayed(this.plugin, scheduledTask -> runnable.run(), l2 * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public MyScheduledTask runTaskTimerAsynchronously(Runnable runnable, long l2, long l3) {
        return new FoliaScheduledTask(this.asyncScheduler.runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), l2 * 50L, l3 * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public MyScheduledTask runTaskAsynchronously(Plugin plugin, Runnable runnable) {
        return new FoliaScheduledTask(this.asyncScheduler.runNow(plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLaterAsynchronously(Plugin plugin, Runnable runnable, long l2) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(this.asyncScheduler.runDelayed(plugin, scheduledTask -> runnable.run(), l2 * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public MyScheduledTask runTaskTimerAsynchronously(Plugin plugin, Runnable runnable, long l2, long l3) {
        l2 = this.getOneIfNotPositive(l2);
        return new FoliaScheduledTask(this.asyncScheduler.runAtFixedRate(plugin, scheduledTask -> runnable.run(), l2 * 50L, l3 * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public void execute(Runnable runnable) {
        this.globalRegionScheduler.execute(this.plugin, runnable);
    }

    @Override
    public void execute(Location location, Runnable runnable) {
        this.regionScheduler.execute(this.plugin, location, runnable);
    }

    @Override
    public void execute(Entity entity, Runnable runnable) {
        entity.getScheduler().execute(this.plugin, runnable, null, 1L);
    }

    @Override
    public void cancelTasks() {
        this.globalRegionScheduler.cancelTasks(this.plugin);
        this.asyncScheduler.cancelTasks(this.plugin);
    }

    @Override
    public void cancelTasks(Plugin plugin) {
        this.globalRegionScheduler.cancelTasks(plugin);
        this.asyncScheduler.cancelTasks(plugin);
    }

    private long getOneIfNotPositive(long l2) {
        return l2 <= 0L ? 1L : l2;
    }
}

