/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.universalScheduler;

import me.ulrich.clans.library.universalScheduler.UniversalScheduler;
import me.ulrich.clans.library.universalScheduler.scheduling.tasks.MyScheduledTask;
import org.bukkit.plugin.Plugin;

public abstract class UniversalRunnable
implements Runnable {
    MyScheduledTask task;

    public synchronized void cancel() {
        this.checkScheduled();
        this.task.cancel();
    }

    public synchronized boolean isCancelled() {
        this.checkScheduled();
        return this.task.isCancelled();
    }

    public synchronized MyScheduledTask runTask(Plugin plugin) {
        this.checkNotYetScheduled();
        return this.setupTask(UniversalScheduler.getScheduler(plugin).runTask(this));
    }

    public synchronized MyScheduledTask runTaskAsynchronously(Plugin plugin) {
        this.checkNotYetScheduled();
        return this.setupTask(UniversalScheduler.getScheduler(plugin).runTaskAsynchronously(this));
    }

    public synchronized MyScheduledTask runTaskLater(Plugin plugin, long l2) {
        this.checkNotYetScheduled();
        return this.setupTask(UniversalScheduler.getScheduler(plugin).runTaskLater(this, l2));
    }

    public synchronized MyScheduledTask runTaskLaterAsynchronously(Plugin plugin, long l2) {
        this.checkNotYetScheduled();
        return this.setupTask(UniversalScheduler.getScheduler(plugin).runTaskLaterAsynchronously(this, l2));
    }

    public synchronized MyScheduledTask runTaskTimer(Plugin plugin, long l2, long l3) {
        this.checkNotYetScheduled();
        return this.setupTask(UniversalScheduler.getScheduler(plugin).runTaskTimer(this, l2, l3));
    }

    public synchronized MyScheduledTask runTaskTimerAsynchronously(Plugin plugin, long l2, long l3) {
        this.checkNotYetScheduled();
        return this.setupTask(UniversalScheduler.getScheduler(plugin).runTaskTimerAsynchronously(this, l2, l3));
    }

    private void checkScheduled() {
        if (this.task == null) {
            throw new IllegalStateException("Not scheduled yet");
        }
    }

    private void checkNotYetScheduled() {
        if (this.task != null) {
            throw new IllegalStateException("Already scheduled");
        }
    }

    private MyScheduledTask setupTask(MyScheduledTask myScheduledTask) {
        this.task = myScheduledTask;
        return myScheduledTask;
    }
}

