/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.team;

import java.util.Iterator;
import java.util.logging.Level;
import me.ulrich.clans.library.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.scheduler.RunningTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerImpl;
import org.jetbrains.annotations.NotNull;

public class TeamUpdaterTask
implements Runnable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final RunningTask task;
    private final Object lock = new Object();

    public TeamUpdaterTask(@NotNull ScoreboardLibraryImpl scoreboardLibraryImpl) {
        this.scoreboardLibrary = scoreboardLibraryImpl;
        this.task = scoreboardLibraryImpl.taskScheduler().runEveryTick(this);
    }

    @NotNull
    public RunningTask task() {
        return this.task;
    }

    @NotNull
    public Object lock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<TeamManagerImpl> iterator = this.scoreboardLibrary.teamManagers().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                TeamManagerImpl teamManagerImpl = iterator.next();
                try {
                    bl = teamManagerImpl.tick();
                }
                catch (Exception exception) {
                    this.scoreboardLibrary.plugin().getLogger().log(Level.WARNING, "an error occurred while updating a TeamManager instance", exception);
                    continue;
                }
                if (bl) continue;
                iterator.remove();
            }
        }
    }
}

