/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.team;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.ulrich.clans.library.scoreboardlibrary.api.team.ScoreboardTeam;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamDisplay;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamManager;
import me.ulrich.clans.library.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.PlayerDisplayable;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.ScoreboardTeamImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamDisplayImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamManagerImpl
implements TeamManager,
PlayerDisplayable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final Set<Player> players = CollectionProvider.set(8);
    private final List<Player> internalPlayers = CollectionProvider.list(8);
    private final Map<String, ScoreboardTeamImpl> teams = new ConcurrentHashMap<String, ScoreboardTeamImpl>();
    private final Queue<TeamManagerTask> taskQueue = new ConcurrentLinkedQueue<TeamManagerTask>();
    private boolean closed;

    public TeamManagerImpl(@NotNull ScoreboardLibraryImpl scoreboardLibraryImpl) {
        this.scoreboardLibrary = scoreboardLibraryImpl;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.add(TeamManagerTask.Close.INSTANCE);
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @Override
    @NotNull
    public Collection<ScoreboardTeam> teams() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableCollection(this.teams.values());
    }

    @Override
    @Nullable
    public ScoreboardTeam team(@NotNull String string) {
        return this.teams.get(string.toLowerCase());
    }

    @Override
    public boolean teamExists(@NotNull String string) {
        return this.teams.containsKey(string.toLowerCase());
    }

    @Override
    @NotNull
    public ScoreboardTeam createIfAbsent(@NotNull String string, @Nullable BiFunction<Player, ScoreboardTeam, TeamDisplay> biFunction) {
        Preconditions.checkNotNull((Object)string);
        this.checkClosed();
        string = string.toLowerCase();
        ScoreboardTeamImpl scoreboardTeamImpl = this.teams.get(string);
        if (scoreboardTeamImpl != null) {
            return scoreboardTeamImpl;
        }
        scoreboardTeamImpl = new ScoreboardTeamImpl(this, string);
        this.teams.put(string, scoreboardTeamImpl);
        for (Player player : this.players) {
            TeamDisplayImpl teamDisplayImpl = biFunction == null ? scoreboardTeamImpl.defaultDisplay() : biFunction.apply(player, scoreboardTeamImpl);
            this.validateTeamDisplay(scoreboardTeamImpl, teamDisplayImpl);
            scoreboardTeamImpl.displayMap().put(player, teamDisplayImpl);
        }
        TeamManagerTask.AddTeam addTeam = new TeamManagerTask.AddTeam(scoreboardTeamImpl);
        this.taskQueue.add(addTeam);
        return scoreboardTeamImpl;
    }

    @Override
    public boolean removeTeam(@NotNull String string) {
        Preconditions.checkNotNull((Object)string);
        this.checkClosed();
        ScoreboardTeamImpl scoreboardTeamImpl = this.teams.remove(string.toLowerCase());
        if (scoreboardTeamImpl != null) {
            this.taskQueue.add(new TeamManagerTask.RemoveTeam(scoreboardTeamImpl));
            return true;
        }
        return false;
    }

    @Override
    public void removeTeam(@NotNull ScoreboardTeam scoreboardTeam) {
        Preconditions.checkNotNull((Object)scoreboardTeam);
        Preconditions.checkArgument((scoreboardTeam.teamManager() == this ? 1 : 0) != 0);
        this.checkClosed();
        if (this.teams.remove(scoreboardTeam.name(), (ScoreboardTeamImpl)scoreboardTeam)) {
            this.taskQueue.add(new TeamManagerTask.RemoveTeam((ScoreboardTeamImpl)scoreboardTeam));
        }
    }

    @Override
    public boolean addPlayer(@NotNull Player player, @Nullable Function<ScoreboardTeam, TeamDisplay> function) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.add(player)) {
            return false;
        }
        for (ScoreboardTeamImpl scoreboardTeamImpl : this.teams.values()) {
            TeamDisplayImpl teamDisplayImpl = function == null ? scoreboardTeamImpl.defaultDisplay() : function.apply(scoreboardTeamImpl);
            this.validateTeamDisplay(scoreboardTeamImpl, teamDisplayImpl);
            scoreboardTeamImpl.displayMap().put(player, teamDisplayImpl);
        }
        this.taskQueue.add(new TeamManagerTask.AddPlayer(player));
        return true;
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.remove(player)) {
            return false;
        }
        TeamManagerTask.RemovePlayer removePlayer = new TeamManagerTask.RemovePlayer(player);
        this.taskQueue.add(removePlayer);
        return true;
    }

    @NotNull
    public ScoreboardLibraryImpl scoreboardLibrary() {
        return this.scoreboardLibrary;
    }

    @NotNull
    public Queue<TeamManagerTask> taskQueue() {
        return this.taskQueue;
    }

    @Override
    public void display(@NotNull Player player) {
        for (ScoreboardTeamImpl scoreboardTeamImpl : this.teams.values()) {
            scoreboardTeamImpl.addPlayer(player);
        }
    }

    public boolean tick() {
        TeamManagerTask teamManagerTask;
        while ((teamManagerTask = this.taskQueue.poll()) != null) {
            Object object;
            Object object22;
            if (teamManagerTask instanceof TeamManagerTask.Close) {
                for (ScoreboardTeamImpl scoreboardTeamImpl : this.teams.values()) {
                    object22 = CollectionProvider.set(this.internalPlayers.size());
                    for (TeamDisplayImpl teamDisplayImpl : scoreboardTeamImpl.displayMap().values()) {
                        object22.addAll(teamDisplayImpl.players());
                    }
                    scoreboardTeamImpl.packetAdapter().removeTeam((Iterable<Player>)object22);
                }
                for (Player player : this.internalPlayers) {
                    Objects.requireNonNull(this.scoreboardLibrary.getPlayer(player)).teamManagerQueue().remove(this);
                }
                return false;
            }
            if (teamManagerTask instanceof TeamManagerTask.AddPlayer) {
                object = (TeamManagerTask.AddPlayer)teamManagerTask;
                @NotNull ScoreboardLibraryPlayer scoreboardLibraryPlayer = this.scoreboardLibrary.getOrCreatePlayer(((TeamManagerTask.AddPlayer)object).player());
                scoreboardLibraryPlayer.teamManagerQueue().add(this);
                this.internalPlayers.add(((TeamManagerTask.AddPlayer)object).player());
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.RemovePlayer) {
                object = (TeamManagerTask.RemovePlayer)teamManagerTask;
                for (Object object22 : this.teams.values()) {
                    ((ScoreboardTeamImpl)object22).removePlayer(((TeamManagerTask.RemovePlayer)object).player());
                }
                this.internalPlayers.remove(((TeamManagerTask.RemovePlayer)object).player());
                Objects.requireNonNull(this.scoreboardLibrary.getPlayer(((TeamManagerTask.RemovePlayer)object).player())).teamManagerQueue().remove(this);
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.ReloadPlayer) {
                object = (TeamManagerTask.ReloadPlayer)teamManagerTask;
                for (Object object22 : this.teams.values()) {
                    TeamDisplayImpl teamDisplayImpl = ((ScoreboardTeamImpl)object22).displayMap().get(((TeamManagerTask.ReloadPlayer)object).player());
                    if (teamDisplayImpl == null) continue;
                    teamDisplayImpl.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, Collections.singleton(((TeamManagerTask.ReloadPlayer)object).player()));
                }
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.AddTeam) {
                object = (TeamManagerTask.AddTeam)teamManagerTask;
                ScoreboardTeamImpl scoreboardTeamImpl = ((TeamManagerTask.AddTeam)object).team();
                object22 = scoreboardTeamImpl.displayMap().keySet().iterator();
                while (object22.hasNext()) {
                    Player player = (Player)object22.next();
                    ScoreboardLibraryPlayer scoreboardLibraryPlayer = this.scoreboardLibrary.getPlayer(player);
                    if (scoreboardLibraryPlayer == null || scoreboardLibraryPlayer.teamManagerQueue().current() != this) continue;
                    scoreboardTeamImpl.addPlayer(player);
                }
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.RemoveTeam) {
                object = (TeamManagerTask.RemoveTeam)teamManagerTask;
                List<Player> list = CollectionProvider.list(((TeamManagerTask.RemoveTeam)object).team().displayMap().size());
                object22 = ((TeamManagerTask.RemoveTeam)object).team().displayMap().entrySet().iterator();
                while (object22.hasNext()) {
                    Map.Entry<Player, TeamDisplayImpl> entry = object22.next();
                    Player player = entry.getKey();
                    TeamDisplayImpl teamDisplayImpl = entry.getValue();
                    if (!teamDisplayImpl.players().contains(player)) continue;
                    list.add(player);
                }
                ((TeamManagerTask.RemoveTeam)object).team().packetAdapter().removeTeam(list);
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.UpdateTeamDisplay) {
                object = (TeamManagerTask.UpdateTeamDisplay)teamManagerTask;
                @NotNull TeamDisplayImpl teamDisplayImpl = ((TeamManagerTask.UpdateTeamDisplay)object).teamDisplay();
                teamDisplayImpl.handleUpdateDisplay();
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.AddEntries) {
                object = (TeamManagerTask.AddEntries)teamManagerTask;
                @NotNull TeamDisplayImpl teamDisplayImpl = ((TeamManagerTask.AddEntries)object).teamDisplay();
                teamDisplayImpl.handleAddEntries(((TeamManagerTask.AddEntries)object).entries());
                continue;
            }
            if (teamManagerTask instanceof TeamManagerTask.RemoveEntries) {
                object = (TeamManagerTask.RemoveEntries)teamManagerTask;
                @NotNull TeamDisplayImpl teamDisplayImpl = ((TeamManagerTask.RemoveEntries)object).teamDisplay();
                teamDisplayImpl.handleRemoveEntries(((TeamManagerTask.RemoveEntries)object).entries());
                continue;
            }
            if (!(teamManagerTask instanceof TeamManagerTask.ChangeTeamDisplay)) continue;
            object = (TeamManagerTask.ChangeTeamDisplay)teamManagerTask;
            ((TeamManagerTask.ChangeTeamDisplay)object).team().changeTeamDisplay(((TeamManagerTask.ChangeTeamDisplay)object).player(), ((TeamManagerTask.ChangeTeamDisplay)object).oldTeamDisplay(), ((TeamManagerTask.ChangeTeamDisplay)object).newTeamDisplay());
        }
        return true;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("TeamManager is closed");
        }
    }

    private void validateTeamDisplay(@NotNull ScoreboardTeam scoreboardTeam, @Nullable TeamDisplay teamDisplay) {
        if (teamDisplay == null || teamDisplay.team() != scoreboardTeam) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        if (!(teamDisplay instanceof TeamDisplayImpl)) {
            throw new IllegalArgumentException("must be TeamDisplayImpl");
        }
    }
}

