/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.team;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.scoreboardlibrary.api.team.ScoreboardTeam;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamDisplay;
import me.ulrich.clans.library.scoreboardlibrary.api.team.enums.CollisionRule;
import me.ulrich.clans.library.scoreboardlibrary.api.team.enums.NameTagVisibility;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.ScoreboardTeamImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamDisplayImpl
implements TeamDisplay,
ImmutableTeamProperties<Component> {
    private final ScoreboardTeamImpl team;
    private final TeamDisplayPacketAdapter packetAdapter;
    private final Set<Player> players = CollectionProvider.set(4);
    private final List<String> entries = CollectionProvider.list(4);
    private final List<String> syncedEntries = CollectionProvider.list(4);
    private Component displayName = Component.empty();
    private Component prefix = Component.empty();
    private Component suffix = Component.empty();
    private boolean friendlyFire;
    private boolean canSeeFriendlyInvisibles;
    private NameTagVisibility nameTagVisibility = NameTagVisibility.ALWAYS;
    private CollisionRule collisionRule = CollisionRule.ALWAYS;
    private NamedTextColor playerColor = null;

    public TeamDisplayImpl(@NotNull ScoreboardTeamImpl scoreboardTeamImpl) {
        this.team = scoreboardTeamImpl;
        this.packetAdapter = scoreboardTeamImpl.packetAdapter().createTeamDisplayAdapter(this);
        this.packetAdapter.updateTeamPackets();
    }

    @Override
    @NotNull
    public ScoreboardTeam team() {
        return this.team;
    }

    @Override
    @NotNull
    public Collection<String> entries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    @NotNull
    public Collection<String> syncedEntries() {
        return this.syncedEntries;
    }

    @Override
    public boolean addEntry(@NotNull String string) {
        if (!this.entries.contains(string)) {
            this.entries.add(string);
            this.team.teamManager().taskQueue().add(new TeamManagerTask.AddEntries(this, Collections.singleton(string)));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEntry(@NotNull String string) {
        if (this.entries.remove(string)) {
            this.team.teamManager().taskQueue().add(new TeamManagerTask.RemoveEntries(this, Collections.singleton(string)));
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Component displayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public TeamDisplay displayName(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        Component component = componentLike.asComponent();
        if (!Objects.equals(this.displayName, component)) {
            this.displayName = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public Component prefix() {
        return this.prefix;
    }

    @Override
    @NotNull
    public TeamDisplay prefix(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        Component component = componentLike.asComponent();
        if (!Objects.equals(this.prefix, component)) {
            this.prefix = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public Component suffix() {
        return this.suffix;
    }

    @Override
    @NotNull
    public TeamDisplay suffix(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        Component component = componentLike.asComponent();
        if (!Objects.equals(this.suffix, component)) {
            this.suffix = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    @Override
    @NotNull
    public TeamDisplay friendlyFire(boolean bl) {
        if (this.friendlyFire != bl) {
            this.friendlyFire = bl;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    public boolean canSeeFriendlyInvisibles() {
        return this.canSeeFriendlyInvisibles;
    }

    @Override
    @NotNull
    public TeamDisplay canSeeFriendlyInvisibles(boolean bl) {
        if (this.canSeeFriendlyInvisibles != bl) {
            this.canSeeFriendlyInvisibles = bl;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public NameTagVisibility nameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    @NotNull
    public TeamDisplay nameTagVisibility(@NotNull NameTagVisibility nameTagVisibility) {
        Preconditions.checkNotNull((Object)((Object)nameTagVisibility));
        if (!Objects.equals((Object)this.nameTagVisibility, (Object)nameTagVisibility)) {
            this.nameTagVisibility = nameTagVisibility;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public CollisionRule collisionRule() {
        return this.collisionRule;
    }

    @Override
    @NotNull
    public TeamDisplay collisionRule(@NotNull CollisionRule collisionRule) {
        Preconditions.checkNotNull((Object)((Object)collisionRule));
        if (!Objects.equals((Object)this.collisionRule, (Object)collisionRule)) {
            this.collisionRule = collisionRule;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @Nullable
    public NamedTextColor playerColor() {
        return this.playerColor;
    }

    @Override
    @NotNull
    public TeamDisplay playerColor(@Nullable NamedTextColor namedTextColor) {
        if (!Objects.equals(this.playerColor, namedTextColor)) {
            this.playerColor = namedTextColor;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    public void refresh() {
        this.scheduleUpdate();
    }

    @NotNull
    public TeamDisplayPacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Set<Player> players() {
        return this.players;
    }

    public void handleUpdateDisplay() {
        this.packetAdapter.updateTeamPackets();
        this.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, this.players());
    }

    public void handleAddEntries(@NotNull Collection<String> collection) {
        this.packetAdapter.sendEntries(EntriesPacketType.ADD, this.players(), collection);
        this.syncedEntries.addAll(collection);
        this.packetAdapter.updateTeamPackets();
    }

    public void handleRemoveEntries(@NotNull Collection<String> collection) {
        this.packetAdapter.sendEntries(EntriesPacketType.REMOVE, this.players(), collection);
        this.syncedEntries.removeAll(collection);
        this.packetAdapter.updateTeamPackets();
    }

    private void scheduleUpdate() {
        Queue<TeamManagerTask> queue = this.team.teamManager().taskQueue();
        TeamManagerTask teamManagerTask = queue.peek();
        if (teamManagerTask instanceof TeamManagerTask.UpdateTeamDisplay && ((TeamManagerTask.UpdateTeamDisplay)teamManagerTask).teamDisplay() == this) {
            return;
        }
        queue.add(new TeamManagerTask.UpdateTeamDisplay(this));
    }
}

