/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.team;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.ulrich.clans.library.scoreboardlibrary.api.team.ScoreboardTeam;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamDisplay;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamDisplayImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ScoreboardTeamImpl
implements ScoreboardTeam {
    private final TeamManagerImpl teamManager;
    private final String name;
    private final TeamsPacketAdapter packetAdapter;
    private final TeamDisplayImpl defaultDisplay;
    private final Map<Player, TeamDisplayImpl> displayMap = new ConcurrentHashMap<Player, TeamDisplayImpl>();

    public ScoreboardTeamImpl(@NotNull TeamManagerImpl teamManagerImpl, @NotNull String string) {
        this.teamManager = teamManagerImpl;
        this.name = string;
        this.packetAdapter = teamManagerImpl.scoreboardLibrary().packetAdapter().createTeamPacketAdapter(string);
        this.defaultDisplay = new TeamDisplayImpl(this);
    }

    @Override
    @NotNull
    public TeamManagerImpl teamManager() {
        return this.teamManager;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public TeamDisplayImpl defaultDisplay() {
        return this.defaultDisplay;
    }

    @Override
    @NotNull
    public TeamDisplay display(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        if (!this.teamManager.players().contains(player)) {
            throw new IllegalArgumentException("player not in TeamManager");
        }
        return Objects.requireNonNull(this.displayMap.get(player));
    }

    @Override
    public void display(@NotNull Player player, @NotNull TeamDisplay teamDisplay) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)teamDisplay);
        if (!this.teamManager.players().contains(player)) {
            throw new IllegalArgumentException("player not in TeamManager");
        }
        if (teamDisplay.team() != this || !(teamDisplay instanceof TeamDisplayImpl)) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        TeamDisplayImpl teamDisplayImpl = Objects.requireNonNull(this.displayMap.put(player, (TeamDisplayImpl)teamDisplay));
        if (teamDisplayImpl == teamDisplay) {
            return;
        }
        this.teamManager.taskQueue().add(new TeamManagerTask.ChangeTeamDisplay(player, this, teamDisplayImpl, (TeamDisplayImpl)teamDisplay));
    }

    @Override
    @NotNull
    public TeamDisplay createDisplay() {
        return new TeamDisplayImpl(this);
    }

    @NotNull
    public TeamsPacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Map<Player, TeamDisplayImpl> displayMap() {
        return this.displayMap;
    }

    public void addPlayer(@NotNull Player player) {
        TeamDisplayImpl teamDisplayImpl = Objects.requireNonNull(this.displayMap.get(player));
        if (teamDisplayImpl.players().add(player)) {
            teamDisplayImpl.packetAdapter().sendProperties(PropertiesPacketType.CREATE, Collections.singleton(player));
        }
    }

    public void removePlayer(@NotNull Player player) {
        TeamDisplayImpl teamDisplayImpl = Objects.requireNonNull(this.displayMap.remove(player));
        if (teamDisplayImpl.players().remove(player)) {
            this.packetAdapter.removeTeam(Collections.singleton(player));
        }
    }

    public void changeTeamDisplay(@NotNull Player player, @NotNull TeamDisplayImpl teamDisplayImpl, @NotNull TeamDisplayImpl teamDisplayImpl2) {
        if (!teamDisplayImpl.players().remove(player)) {
            return;
        }
        teamDisplayImpl2.players().add(player);
        Set<Player> set = Collections.singleton(player);
        teamDisplayImpl2.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, set);
        Collection<String> collection = teamDisplayImpl.syncedEntries();
        Collection<String> collection2 = teamDisplayImpl2.syncedEntries();
        if (collection.isEmpty()) {
            teamDisplayImpl2.packetAdapter().sendEntries(EntriesPacketType.ADD, set, collection2);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        arrayList.removeAll(collection2);
        if (!arrayList.isEmpty()) {
            teamDisplayImpl2.packetAdapter().sendEntries(EntriesPacketType.REMOVE, set, arrayList);
        }
        arrayList = new ArrayList<String>(collection2);
        arrayList.removeAll(collection);
        if (!arrayList.isEmpty()) {
            teamDisplayImpl2.packetAdapter().sendEntries(EntriesPacketType.ADD, set, arrayList);
        }
    }
}

