/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.SidebarLineHandler;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale.LocaleLine;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ModernLocaleLine
implements ImmutableTeamProperties<Component>,
LocaleLine {
    private final GlobalLineInfo info;
    private final SidebarLineHandler handler;
    private final Collection<String> entries;
    private final TeamDisplayPacketAdapter packetAdapter;

    public ModernLocaleLine(GlobalLineInfo globalLineInfo, SidebarLineHandler sidebarLineHandler) {
        this.info = globalLineInfo;
        this.handler = sidebarLineHandler;
        this.entries = ImmutableList.of((Object)globalLineInfo.player());
        this.packetAdapter = globalLineInfo.packetAdapter().createTeamDisplayAdapter(this);
        this.packetAdapter.updateTeamPackets();
    }

    @Override
    @NotNull
    public GlobalLineInfo info() {
        return this.info;
    }

    @Override
    public void value(@NotNull Component component) {
    }

    @Override
    public void updateTeam() {
        this.packetAdapter.updateTeamPackets();
        this.packetAdapter.sendProperties(PropertiesPacketType.UPDATE, this.handler.players());
    }

    @Override
    public void sendScore(@NotNull Collection<Player> collection) {
        this.handler.localeLineHandler().sidebar().packetAdapter().sendScore(collection, this.info.player(), this.info.objectiveScore(), null, this.info.scoreFormat());
    }

    @Override
    public void show(@NotNull Collection<Player> collection) {
        this.sendScore(collection);
        this.packetAdapter.sendProperties(PropertiesPacketType.CREATE, collection);
    }

    @Override
    public void hide(@NotNull Collection<Player> collection) {
        this.handler.localeLineHandler().sidebar().packetAdapter().removeScore(collection, this.info.player());
        this.info.packetAdapter().removeTeam(collection);
    }

    @Override
    @NotNull
    public Collection<String> syncedEntries() {
        return this.entries;
    }

    @Override
    @NotNull
    public Component displayName() {
        return Component.empty();
    }

    @Override
    @NotNull
    public Component prefix() {
        Component component = this.info.value();
        return component == null ? Component.empty() : component;
    }

    @Override
    @NotNull
    public Component suffix() {
        return Component.empty();
    }
}

