/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.SidebarLineHandler;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale.LocaleLine;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LegacyLocaleLine
implements ImmutableTeamProperties<String>,
LocaleLine {
    private final GlobalLineInfo info;
    private final SidebarLineHandler handler;
    private final TeamDisplayPacketAdapter packetAdapter;
    private String player;
    private String oldPlayer;
    private String prefix;
    private String suffix;
    private String currentValue;

    public LegacyLocaleLine(GlobalLineInfo globalLineInfo, SidebarLineHandler sidebarLineHandler) {
        this.info = globalLineInfo;
        this.handler = sidebarLineHandler;
        this.player = globalLineInfo.player();
        this.packetAdapter = globalLineInfo.packetAdapter().createLegacyTeamDisplayAdapter(this);
        this.packetAdapter.updateTeamPackets();
    }

    @Override
    @NotNull
    public GlobalLineInfo info() {
        return this.info;
    }

    @Override
    @NotNull
    public String displayName() {
        return "";
    }

    @Override
    @NotNull
    public String prefix() {
        return this.prefix;
    }

    @Override
    @NotNull
    public String suffix() {
        return this.suffix;
    }

    @Override
    @NotNull
    public Collection<String> syncedEntries() {
        return ImmutableList.of((Object)this.player);
    }

    @Override
    public void value(@NotNull Component component) {
        String string = LegacyComponentSerializer.legacySection().serialize(component);
        String string2 = this.player;
        if (string.length() <= 16) {
            this.prefix = string;
            this.suffix = "";
            if (this.currentValue != null && this.currentValue.length() > 32) {
                this.player = this.info.player();
            }
        } else {
            boolean bl = string.charAt(15) == '\u00a7';
            int n2 = bl ? 15 : 16;
            this.prefix = string.substring(0, n2);
            String string3 = this.prefix + '\u00a7' + (bl ? Character.valueOf(string.charAt(16)) : "");
            this.player = this.info.player() + ChatColor.getLastColors((String)string3);
            int n3 = n2;
            if (string.length() > 32) {
                int n4 = 16 - this.player.length();
                assert (n4 > 0);
                this.player = this.player + string.substring(n2, n3 += n4);
            }
            this.suffix = ChatColor.getLastColors((String)this.player) + string.substring(n3 + (bl ? 2 : 0));
            if (this.suffix.length() > 16) {
                String string4 = this.suffix.substring(0, 16);
                if (string4.endsWith(String.valueOf('\u00a7'))) {
                    string4 = string4.substring(0, 15);
                }
                this.suffix = string4;
            }
        }
        this.currentValue = string;
        if (!this.player.equals(string2)) {
            this.oldPlayer = string2;
        }
    }

    @Override
    public void updateTeam() {
        Set<Player> set = this.handler.players();
        if (this.oldPlayer != null) {
            ObjectivePacketAdapter objectivePacketAdapter = this.handler.localeLineHandler().sidebar().packetAdapter();
            this.packetAdapter.sendEntries(EntriesPacketType.REMOVE, set, Collections.singleton(this.oldPlayer));
            objectivePacketAdapter.removeScore(set, this.oldPlayer);
            this.oldPlayer = null;
            this.packetAdapter.sendEntries(EntriesPacketType.ADD, set, Collections.singleton(this.player));
            objectivePacketAdapter.sendScore(set, this.player, this.info.objectiveScore(), null, null);
        }
        this.packetAdapter.sendProperties(PropertiesPacketType.UPDATE, set);
    }

    @Override
    public void resetOldPlayer() {
        this.oldPlayer = null;
    }

    @Override
    public void sendScore(@NotNull Collection<Player> collection) {
        ObjectivePacketAdapter objectivePacketAdapter = this.handler.localeLineHandler().sidebar().packetAdapter();
        if (this.oldPlayer != null) {
            objectivePacketAdapter.removeScore(collection, this.oldPlayer);
        }
        objectivePacketAdapter.sendScore(collection, this.player, this.info.objectiveScore(), null, null);
    }

    @Override
    public void show(@NotNull Collection<Player> collection) {
        this.sendScore(collection);
        this.packetAdapter.sendProperties(PropertiesPacketType.CREATE, collection);
    }

    @Override
    public void hide(@NotNull Collection<Player> collection) {
        ObjectivePacketAdapter objectivePacketAdapter = this.handler.localeLineHandler().sidebar().packetAdapter();
        if (this.oldPlayer != null) {
            objectivePacketAdapter.removeScore(collection, this.oldPlayer);
        }
        objectivePacketAdapter.removeScore(collection, this.player);
        this.info.packetAdapter().removeTeam(collection);
    }
}

