/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line;

import java.util.Collection;
import java.util.Set;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LineRenderingStrategy;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.LocaleLineHandler;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale.LegacyLocaleLine;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale.LocaleLine;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale.ModernLocaleLine;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.locale.PostModernLocaleLine;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SidebarLineHandler {
    private final LineRenderingStrategy strategy;
    private final LocaleLineHandler localeLineHandler;
    private final Set<Player> players = CollectionProvider.set(1);
    private final LocaleLine[] lines;

    public SidebarLineHandler(@NotNull LineRenderingStrategy lineRenderingStrategy, @NotNull LocaleLineHandler localeLineHandler) {
        this.strategy = lineRenderingStrategy;
        this.localeLineHandler = localeLineHandler;
        this.lines = new LocaleLine[localeLineHandler.sidebar().maxLines()];
        for (GlobalLineInfo globalLineInfo : localeLineHandler.sidebar().lines()) {
            Component component;
            if (globalLineInfo == null || (component = globalLineInfo.value()) == null) continue;
            this.setLine(globalLineInfo.line(), GlobalTranslator.render(component, localeLineHandler.locale()));
        }
    }

    @NotNull
    public LocaleLineHandler localeLineHandler() {
        return this.localeLineHandler;
    }

    @NotNull
    public Set<Player> players() {
        return this.players;
    }

    public void updateScores() {
        for (LocaleLine localeLine : this.lines) {
            if (localeLine == null || !localeLine.info().updateScore()) continue;
            localeLine.sendScore(this.players);
        }
    }

    public void updateScore(int n2) {
        LocaleLine localeLine = this.lines[n2];
        localeLine.sendScore(this.players);
    }

    public void setLine(int n2, Component component) {
        LocaleLine localeLine = this.lines[n2];
        if (component == null && localeLine == null) {
            return;
        }
        boolean bl = false;
        if (localeLine == null) {
            this.lines[n2] = localeLine = this.createLine(this.strategy, this.localeLineHandler.sidebar().lines()[n2]);
            bl = true;
        }
        if (component == null) {
            this.lines[n2] = null;
        } else {
            localeLine.value(component);
        }
        if (component == null) {
            localeLine.hide(this.players);
        } else if (bl) {
            localeLine.resetOldPlayer();
            localeLine.show(this.players);
        } else {
            localeLine.updateTeam();
        }
    }

    public void show(Collection<Player> collection) {
        for (LocaleLine localeLine : this.lines) {
            if (localeLine == null) continue;
            localeLine.show(collection);
        }
    }

    public void hide(Collection<Player> collection) {
        for (LocaleLine localeLine : this.lines) {
            if (localeLine == null) continue;
            localeLine.hide(collection);
        }
    }

    @NotNull
    private LocaleLine createLine(@NotNull LineRenderingStrategy lineRenderingStrategy, @NotNull GlobalLineInfo globalLineInfo) {
        switch (lineRenderingStrategy) {
            case LEGACY: {
                return new LegacyLocaleLine(globalLineInfo, this);
            }
            case MODERN: {
                return new ModernLocaleLine(globalLineInfo, this);
            }
            case POST_MODERN: {
                return new PostModernLocaleLine(globalLineInfo, this);
            }
        }
        throw new IllegalArgumentException();
    }
}

