/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line;

import java.util.Collections;
import java.util.Locale;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LineRenderingStrategy;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.SidebarLineHandler;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LocaleLineHandler {
    private final AbstractSidebar sidebar;
    private final Locale locale;
    private final SidebarLineHandler[] lineHandlers;

    public LocaleLineHandler(@NotNull AbstractSidebar abstractSidebar, @NotNull Locale locale) {
        this.sidebar = abstractSidebar;
        this.locale = locale;
        this.lineHandlers = new SidebarLineHandler[LineRenderingStrategy.values().length];
    }

    @NotNull
    public AbstractSidebar sidebar() {
        return this.sidebar;
    }

    @NotNull
    public Locale locale() {
        return this.locale;
    }

    public boolean hasPlayers() {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null || sidebarLineHandler.players().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addPlayer(@NotNull Player player) {
        LineRenderingStrategy lineRenderingStrategy = this.sidebar.scoreboardLibrary().packetAdapter().lineRenderingStrategy(player);
        this.lineHandler(lineRenderingStrategy).players().add(player);
    }

    public void removePlayer(@NotNull Player player) {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null || !sidebarLineHandler.players().remove(player)) continue;
            return;
        }
    }

    @NotNull
    public SidebarLineHandler lineHandler(@NotNull LineRenderingStrategy lineRenderingStrategy) {
        SidebarLineHandler sidebarLineHandler = this.lineHandlers[lineRenderingStrategy.ordinal()];
        if (sidebarLineHandler == null) {
            SidebarLineHandler sidebarLineHandler2 = new SidebarLineHandler(lineRenderingStrategy, this);
            this.lineHandlers[lineRenderingStrategy.ordinal()] = sidebarLineHandler2;
            sidebarLineHandler = sidebarLineHandler2;
        }
        return sidebarLineHandler;
    }

    public void updateScoreFormat(int n2) {
        SidebarLineHandler sidebarLineHandler = this.lineHandlers[LineRenderingStrategy.MODERN.ordinal()];
        if (sidebarLineHandler != null) {
            sidebarLineHandler.updateScore(n2);
        }
    }

    public void updateLine(int n2, Component component) {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null) continue;
            sidebarLineHandler.setLine(n2, component);
        }
    }

    public void updateScores() {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null) continue;
            sidebarLineHandler.updateScores();
        }
    }

    public void show(Player player) {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null || !sidebarLineHandler.players().contains(player)) continue;
            sidebarLineHandler.show(Collections.singleton(player));
            return;
        }
    }

    public void hide(Player player) {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null || !sidebarLineHandler.players().contains(player)) continue;
            sidebarLineHandler.hide(Collections.singleton(player));
            return;
        }
    }

    public void hide() {
        for (SidebarLineHandler sidebarLineHandler : this.lineHandlers) {
            if (sidebarLineHandler == null) continue;
            sidebarLineHandler.hide(sidebarLineHandler.players());
        }
    }
}

