/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.Sidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.PlayerDisplayable;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.SidebarTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.line.LocaleLineHandler;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class AbstractSidebar
implements Sidebar,
PlayerDisplayable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final ObjectivePacketAdapter packetAdapter;
    private final GlobalLineInfo[] lines;
    private Component title = Component.empty();
    private final Set<Player> players = CollectionProvider.set(8);
    private boolean closed;
    private final Queue<SidebarTask> taskQueue = new ConcurrentLinkedQueue<SidebarTask>();

    public AbstractSidebar(@NotNull ScoreboardLibraryImpl scoreboardLibraryImpl, int n2, @NotNull String string) {
        this.scoreboardLibrary = scoreboardLibraryImpl;
        this.packetAdapter = scoreboardLibraryImpl.packetAdapter().createObjectiveAdapter(string);
        this.lines = new GlobalLineInfo[n2];
    }

    @NotNull
    protected abstract Set<Player> internalPlayers();

    protected abstract void forEachLineHandler(@NotNull Consumer<LocaleLineHandler> var1);

    @Nullable
    protected abstract LocaleLineHandler addPlayer0(@NotNull Player var1);

    @Nullable
    protected abstract LocaleLineHandler removePlayer0(@NotNull Player var1);

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.add(SidebarTask.Close.INSTANCE);
        }
    }

    @Override
    public final boolean closed() {
        return this.closed;
    }

    @Override
    @NotNull
    public final Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @Override
    public final boolean addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (this.players.add(player)) {
            this.taskQueue.add(new SidebarTask.AddPlayer(player));
            return true;
        }
        return false;
    }

    @Override
    public final boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (this.players.remove(player)) {
            this.taskQueue.add(new SidebarTask.RemovePlayer(player));
            return true;
        }
        return false;
    }

    @Override
    public final @Range(from=1L, to=15L) int maxLines() {
        return this.lines.length;
    }

    @Override
    @NotNull
    public String objectiveName() {
        return this.packetAdapter.objectiveName();
    }

    @Override
    public final void line(@Range(from=0L, to=14L) int n2, @Nullable ComponentLike componentLike, @Nullable ScoreFormat scoreFormat) {
        boolean bl;
        this.checkClosed();
        Component component = componentLike == null ? null : componentLike.asComponent();
        GlobalLineInfo globalLineInfo = this.getLineInfo(n2);
        boolean bl2 = !Objects.equals(globalLineInfo.value(), component);
        boolean bl3 = bl = !Objects.equals(globalLineInfo.scoreFormat(), scoreFormat);
        if (bl2 || bl) {
            globalLineInfo.value(component);
            globalLineInfo.scoreFormat(scoreFormat);
            this.taskQueue.add(new SidebarTask.UpdateLine(n2, bl2, bl));
            this.updateScores();
        }
    }

    @Override
    public void refreshLine(@Range(from=0L, to=0x7FFFFFFEL) int n2) {
        this.checkClosed();
        GlobalLineInfo globalLineInfo = this.lines[n2];
        if (globalLineInfo != null) {
            boolean bl = globalLineInfo.value() != null;
            boolean bl2 = globalLineInfo.scoreFormat() != null;
            this.taskQueue.add(new SidebarTask.UpdateLine(n2, bl, bl2));
        }
    }

    @Override
    @Nullable
    public final Component line(@Range(from=0L, to=14L) int n2) {
        this.checkClosed();
        GlobalLineInfo globalLineInfo = this.lines[n2];
        return globalLineInfo == null ? null : globalLineInfo.value();
    }

    @Override
    @NotNull
    public final Component title() {
        return this.title;
    }

    @Override
    public final void title(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        this.checkClosed();
        Component component = componentLike.asComponent();
        if (!Objects.equals(this.title, component)) {
            this.title = component;
            this.taskQueue.add(SidebarTask.UpdateTitle.INSTANCE);
        }
    }

    @Override
    public void refreshTitle() {
        this.checkClosed();
        this.taskQueue.add(SidebarTask.UpdateTitle.INSTANCE);
    }

    @NotNull
    public final ScoreboardLibraryImpl scoreboardLibrary() {
        return this.scoreboardLibrary;
    }

    public final ObjectivePacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @Nullable
    public final GlobalLineInfo[] lines() {
        return this.lines;
    }

    @NotNull
    public final Queue<SidebarTask> taskQueue() {
        return this.taskQueue;
    }

    @Override
    public final void display(@NotNull Player player) {
        Set<Player> set = Collections.singleton(player);
        this.packetAdapter.sendProperties(set, PropertiesPacketType.CREATE, this.title, ObjectiveRenderType.INTEGER, ScoreFormat.blank());
        LocaleLineHandler localeLineHandler = Objects.requireNonNull(this.addPlayer0(player));
        localeLineHandler.addPlayer(player);
        localeLineHandler.show(player);
        this.packetAdapter.display(set, ObjectiveDisplaySlot.sidebar());
    }

    public final boolean tick() {
        SidebarTask sidebarTask;
        while ((sidebarTask = this.taskQueue.poll()) != null) {
            if (sidebarTask instanceof SidebarTask.Close) {
                this.forEachLineHandler(LocaleLineHandler::hide);
                this.packetAdapter.remove(this.internalPlayers());
                for (Player player : this.internalPlayers()) {
                    Objects.requireNonNull(this.scoreboardLibrary.getPlayer(player)).sidebarQueue().remove(this);
                }
                return false;
            }
            if (sidebarTask instanceof SidebarTask.AddPlayer) {
                SidebarTask.AddPlayer addPlayer = (SidebarTask.AddPlayer)sidebarTask;
                ScoreboardLibraryPlayer scoreboardLibraryPlayer = this.scoreboardLibrary.getOrCreatePlayer(addPlayer.player());
                scoreboardLibraryPlayer.sidebarQueue().add(this);
                continue;
            }
            if (sidebarTask instanceof SidebarTask.RemovePlayer) {
                SidebarTask.RemovePlayer removePlayer = (SidebarTask.RemovePlayer)sidebarTask;
                LocaleLineHandler localeLineHandler2 = this.removePlayer0(removePlayer.player());
                if (localeLineHandler2 != null) {
                    localeLineHandler2.hide(removePlayer.player());
                    localeLineHandler2.removePlayer(removePlayer.player());
                    this.packetAdapter.remove(Collections.singleton(removePlayer.player()));
                }
                Objects.requireNonNull(this.scoreboardLibrary.getPlayer(removePlayer.player())).sidebarQueue().remove(this);
                continue;
            }
            if (sidebarTask instanceof SidebarTask.ReloadPlayer) {
                SidebarTask.ReloadPlayer reloadPlayer = (SidebarTask.ReloadPlayer)sidebarTask;
                LocaleLineHandler localeLineHandler3 = this.removePlayer0(reloadPlayer.player());
                if (localeLineHandler3 == null) continue;
                this.packetAdapter.remove(Collections.singleton(reloadPlayer.player()));
                localeLineHandler3.hide(reloadPlayer.player());
                localeLineHandler3.removePlayer(reloadPlayer.player());
                this.display(reloadPlayer.player());
                continue;
            }
            if (sidebarTask instanceof SidebarTask.UpdateLine) {
                SidebarTask.UpdateLine updateLine = (SidebarTask.UpdateLine)sidebarTask;
                this.forEachLineHandler(localeLineHandler -> {
                    if (updateLine.updateValue()) {
                        Component component = this.lines[updateLine.line()].value();
                        Component component2 = component == null ? null : GlobalTranslator.render(component, localeLineHandler.locale());
                        localeLineHandler.updateLine(updateLine.line(), component2);
                    }
                    if (updateLine.updateScore()) {
                        localeLineHandler.updateScoreFormat(updateLine.line());
                    }
                });
                continue;
            }
            if (sidebarTask instanceof SidebarTask.UpdateScores) {
                this.forEachLineHandler(LocaleLineHandler::updateScores);
                for (GlobalLineInfo globalLineInfo : this.lines) {
                    if (globalLineInfo == null) continue;
                    globalLineInfo.updateScore(false);
                }
                continue;
            }
            if (!(sidebarTask instanceof SidebarTask.UpdateTitle)) continue;
            this.packetAdapter.sendProperties(this.internalPlayers(), PropertiesPacketType.UPDATE, this.title, ObjectiveRenderType.INTEGER, ScoreFormat.blank());
        }
        return true;
    }

    private void updateScores() {
        int n2 = 0;
        for (GlobalLineInfo globalLineInfo : this.lines) {
            if (globalLineInfo == null || globalLineInfo.value() == null) continue;
            ++n2;
        }
        boolean bl = false;
        int n3 = 0;
        for (GlobalLineInfo globalLineInfo : this.lines) {
            if (globalLineInfo == null || globalLineInfo.value() == null) continue;
            int n4 = n2 - n3 - 1;
            if (globalLineInfo.objectiveScore() != n4) {
                bl = true;
                globalLineInfo.updateScore(true);
                globalLineInfo.objectiveScore(n4);
            }
            ++n3;
        }
        if (bl) {
            this.taskQueue.add(SidebarTask.UpdateScores.INSTANCE);
        }
    }

    @NotNull
    private GlobalLineInfo getLineInfo(int n2) {
        GlobalLineInfo globalLineInfo = this.lines[n2];
        if (globalLineInfo == null) {
            char c2 = Character.toChars(128 + n2)[0];
            String string = "\u00a7" + c2;
            globalLineInfo = this.lines[n2] = new GlobalLineInfo(this, string, n2);
            this.updateScores();
        }
        return globalLineInfo;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Sidebar is closed");
        }
    }
}

