/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.scheduler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.ulrich.clans.library.scoreboardlibrary.implementation.scheduler.RunningTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.scheduler.TaskScheduler;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class FoliaTaskScheduler
implements TaskScheduler {
    private static final Class<?> asyncSchedulerClass;
    private static final Class<?> scheduledTaskClass;
    private static final Class<?> cancelledStateClass;
    private static final MethodHandle getAsyncSchedulerMethod;
    private static final MethodHandle cancelScheduledTaskMethod;
    private static final MethodHandle runAtFixedRateMethod;
    private static final MethodHandle runDelayedMethod;
    private final Plugin plugin;
    private final Object asyncScheduler;

    public FoliaTaskScheduler(@NotNull Plugin plugin) {
        this.plugin = plugin;
        try {
            this.asyncScheduler = getAsyncSchedulerMethod.invoke(plugin.getServer());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("couldn't get async scheduler", throwable);
        }
    }

    @Override
    @NotNull
    public RunningTask runEveryTick(@NotNull Runnable runnable) {
        Object object2;
        try {
            Consumer<Object> consumer = object -> runnable.run();
            object2 = runAtFixedRateMethod.invoke(this.asyncScheduler, this.plugin, consumer, 50L, 50L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("couldn't schedule repeating task", throwable);
        }
        return () -> {
            try {
                cancelScheduledTaskMethod.invoke(object2);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("couldn't cancel scheduled task", throwable);
            }
        };
    }

    @Override
    public void runNextTick(@NotNull Runnable runnable) {
        Consumer<Object> consumer = object -> runnable.run();
        try {
            runDelayedMethod.invoke(this.asyncScheduler, this.plugin, consumer, 50L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("couldn't schedule delayed task", throwable);
        }
    }

    static {
        try {
            asyncSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            scheduledTaskClass = Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
            cancelledStateClass = Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask$CancelledState");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            getAsyncSchedulerMethod = lookup.findVirtual(Server.class, "getAsyncScheduler", MethodType.methodType(asyncSchedulerClass));
            cancelScheduledTaskMethod = lookup.findVirtual(scheduledTaskClass, "cancel", MethodType.methodType(cancelledStateClass));
            runAtFixedRateMethod = lookup.findVirtual(asyncSchedulerClass, "runAtFixedRate", MethodType.methodType(scheduledTaskClass, Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class));
            runDelayedMethod = lookup.findVirtual(asyncSchedulerClass, "runDelayed", MethodType.methodType(scheduledTaskClass, Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

