/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.player;

import me.ulrich.clans.library.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ObjectiveManagerImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.PlayerDependantLocaleSidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.SidebarTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.jetbrains.annotations.NotNull;

public class LocaleListener
implements Listener {
    private final ScoreboardLibraryImpl scoreboardLibrary;

    public LocaleListener(@NotNull ScoreboardLibraryImpl scoreboardLibraryImpl) {
        this.scoreboardLibrary = scoreboardLibraryImpl;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerLocaleChanged(PlayerLocaleChangeEvent playerLocaleChangeEvent) {
        Player player = playerLocaleChangeEvent.getPlayer();
        this.scoreboardLibrary.taskScheduler().runNextTick(() -> {
            ScoreboardLibraryPlayer scoreboardLibraryPlayer = this.scoreboardLibrary.getPlayer(player);
            if (scoreboardLibraryPlayer != null) {
                AbstractSidebar abstractSidebar;
                ObjectiveManagerImpl objectiveManagerImpl;
                TeamManagerImpl teamManagerImpl = scoreboardLibraryPlayer.teamManagerQueue().current();
                if (teamManagerImpl != null) {
                    teamManagerImpl.taskQueue().add(new TeamManagerTask.ReloadPlayer(player));
                }
                if ((objectiveManagerImpl = scoreboardLibraryPlayer.objectiveManagerQueue().current()) != null) {
                    objectiveManagerImpl.taskQueue().add(new ObjectiveManagerTask.ReloadPlayer(player));
                }
                if ((abstractSidebar = scoreboardLibraryPlayer.sidebarQueue().current()) instanceof PlayerDependantLocaleSidebar) {
                    abstractSidebar.taskQueue().add(new SidebarTask.ReloadPlayer(player));
                }
            }
        });
    }
}

