/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.player;

import java.util.List;
import java.util.UUID;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.PlayerDisplayable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayableQueue<T extends PlayerDisplayable> {
    private final UUID playerUuid;
    private final List<T> queue = CollectionProvider.list(1);

    public DisplayableQueue(@NotNull UUID uUID) {
        this.playerUuid = uUID;
    }

    @Nullable
    public synchronized T current() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return (T)((PlayerDisplayable)this.queue.get(0));
    }

    public synchronized void add(@NotNull T t2) {
        Player player;
        if (this.queue.contains(t2)) {
            throw new IllegalStateException("displayable already registered");
        }
        this.queue.add(t2);
        if (this.current() == t2 && (player = Bukkit.getPlayer((UUID)this.playerUuid)) != null) {
            t2.display(player);
        }
    }

    public synchronized void remove(@NotNull T t2) {
        Player player;
        boolean bl;
        boolean bl2 = bl = t2 == this.current();
        if (!this.queue.remove(t2)) {
            throw new IllegalStateException("displayable not registered");
        }
        if (!bl) {
            return;
        }
        T t3 = this.current();
        if (t3 != null && (player = Bukkit.getPlayer((UUID)this.playerUuid)) != null) {
            t3.display(player);
        }
    }
}

