/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.reflect.ConstructorAccessor;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.reflect.FieldAccessor;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.reflect.PacketConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectUtil {
    private static final Object UNSAFE;
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodHandle ALLOCATE_INSTANCE_HANDLE;
    private static final MethodType VOID_METHOD_TYPE;
    private static final MethodType VIRTUAL_FIELD_SETTER;

    private ReflectUtil() {
    }

    @NotNull
    public static Class<?> getClassOrThrow(String ... stringArray) {
        Class<?> clazz = ReflectUtil.getOptionalClass(stringArray);
        if (clazz == null) {
            throw new IllegalStateException("Class with names either of " + String.join((CharSequence)", ", stringArray) + " not found");
        }
        return clazz;
    }

    @Nullable
    public static Class<?> getOptionalClass(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @NotNull
    public static Object getEnumInstance(@NotNull Class<?> clazz, String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalStateException("Enum " + clazz.getName() + " instance with names either of  " + String.join((CharSequence)",", stringArray) + " not found");
    }

    @NotNull
    public static <T, V> FieldAccessor<T, V> findField(@NotNull Class<T> clazz, int n2, @NotNull Class<V> clazz2) {
        return ReflectUtil.findFieldUnchecked(clazz, n2, clazz2);
    }

    @NotNull
    public static <T, V> FieldAccessor<T, V> findFieldUnchecked(@NotNull Class<?> clazz, int n2, @NotNull Class<?> clazz2) {
        int n3 = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.getType() != clazz2) continue;
            if (n3 == n2) {
                try {
                    MethodHandle methodHandle = LOOKUP.unreflectSetter(field);
                    return new FieldAccessor(methodHandle.asType(VIRTUAL_FIELD_SETTER));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("failed to unreflect field setter", illegalAccessException);
                }
            }
            ++n3;
        }
        throw new IllegalStateException("couldn't find field with class " + clazz2.getSimpleName() + " on " + clazz.getSimpleName() + " at index " + n2);
    }

    @Nullable
    public static <T> ConstructorAccessor<T> findOptionalConstructor(@NotNull Class<T> clazz, Class<?> ... classArray) {
        try {
            MethodHandle methodHandle = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, classArray));
            return new ConstructorAccessor(ReflectUtil.convertToGeneric(methodHandle));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    @NotNull
    public static <T> ConstructorAccessor<T> findConstructor(@NotNull Class<T> clazz, Class<?> ... classArray) {
        ConstructorAccessor<T> constructorAccessor = ReflectUtil.findOptionalConstructor(clazz, classArray);
        if (constructorAccessor == null) {
            throw new RuntimeException("Constructor for class " + clazz.getName() + " not found");
        }
        return constructorAccessor;
    }

    @NotNull
    public static <T> PacketConstructor<T> getEmptyConstructor(@NotNull Class<T> clazz) {
        try {
            MethodHandle methodHandle = LOOKUP.findConstructor(clazz, VOID_METHOD_TYPE);
            return () -> {
                try {
                    return methodHandle.invoke();
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("couldn't create packet instance", throwable);
                }
            };
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return () -> {
                try {
                    return ALLOCATE_INSTANCE_HANDLE.invoke(UNSAFE, clazz);
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("couldn't allocate packet instance using Unsafe", throwable);
                }
            };
        }
    }

    @NotNull
    private static MethodHandle convertToGeneric(@NotNull MethodHandle methodHandle) {
        MethodHandle methodHandle2 = methodHandle.asFixedArity();
        MethodType methodType = MethodType.genericMethodType(0, true);
        methodHandle2 = methodHandle2.asSpreader(Object[].class, methodHandle.type().parameterCount());
        return methodHandle2.asType(methodType);
    }

    static {
        Object object;
        Object object2;
        VOID_METHOD_TYPE = MethodType.methodType(Void.TYPE);
        VIRTUAL_FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class, Object.class);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            object2 = Class.forName("sun.misc.Unsafe");
            object = ((Class)object2).getDeclaredField("theUnsafe");
            ((Field)object).setAccessible(true);
            UNSAFE = ((Field)object).get(null);
            ALLOCATE_INSTANCE_HANDLE = lookup.findVirtual(UNSAFE.getClass(), "allocateInstance", MethodType.methodType(Object.class, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
        try {
            object = lookup.findVirtual(UNSAFE.getClass(), "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
            MethodHandle methodHandle = lookup.findVirtual(UNSAFE.getClass(), "staticFieldBase", MethodType.methodType(Object.class, Field.class));
            MethodHandle methodHandle2 = lookup.findVirtual(UNSAFE.getClass(), "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE));
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long l2 = object.invoke(UNSAFE, field);
            Object object3 = methodHandle.invoke(UNSAFE, field);
            object2 = methodHandle2.invoke(UNSAFE, object3, l2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            object2 = lookup;
        }
        LOOKUP = object2;
    }
}

