/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LocaleProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class LocalePacketUtil {
    private LocalePacketUtil() {
    }

    public static <P> void sendLocalePackets(@NotNull PacketSender<P> packetSender, @NotNull Collection<Player> collection, @NotNull Function<Locale, P> function) {
        if (collection.isEmpty()) {
            return;
        }
        if (collection.size() == 1) {
            Player player = collection.iterator().next();
            P p2 = function.apply(LocaleProvider.locale(player));
            packetSender.sendPacket(player, p2);
            return;
        }
        Map<Locale, Object> map = CollectionProvider.map(1);
        for (Player player : collection) {
            Locale locale = LocaleProvider.locale(player);
            Object object = map.computeIfAbsent(locale, locale2 -> function.apply(locale));
            packetSender.sendPacket(player, object);
        }
    }
}

