/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents.team;

import com.google.common.base.Preconditions;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.packetevents.manager.server.ServerVersion;
import me.ulrich.clans.library.packetevents.protocol.packettype.PacketType;
import me.ulrich.clans.library.packetevents.protocol.packettype.PacketTypeCommon;
import me.ulrich.clans.library.packetevents.util.ColorUtil;
import me.ulrich.clans.library.packetevents.wrapper.PacketWrapper;
import me.ulrich.clans.library.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import me.ulrich.clans.library.scoreboardlibrary.api.team.enums.NameTagVisibility;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;

public class WrapperPlayServerTeamsLegacy
extends PacketWrapper<WrapperPlayServerTeamsLegacy> {
    private final String teamName;
    private final ImmutableTeamProperties<String> properties;
    private final WrapperPlayServerTeams.TeamMode teamMode;

    public WrapperPlayServerTeamsLegacy(String string, ImmutableTeamProperties<String> immutableTeamProperties, WrapperPlayServerTeams.TeamMode teamMode) {
        super((PacketTypeCommon)PacketType.Play.Server.TEAMS);
        this.teamName = string;
        this.properties = immutableTeamProperties;
        Preconditions.checkArgument((teamMode == WrapperPlayServerTeams.TeamMode.CREATE || teamMode == WrapperPlayServerTeams.TeamMode.UPDATE ? 1 : 0) != 0);
        this.teamMode = teamMode;
    }

    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            throw new IllegalStateException("Tried to serialize legacy teams packet on 1.13+ server version");
        }
        this.writeString(this.teamName, 16);
        this.writeByte(this.teamMode.ordinal());
        this.writeString(this.properties.displayName());
        this.writeString(this.properties.prefix());
        this.writeString(this.properties.suffix());
        this.writeByte(this.properties.packOptions());
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeString(NameTagVisibility.ALWAYS.key());
            this.writeByte(15);
        } else {
            this.writeString(this.properties.nameTagVisibility().key());
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                this.writeString(this.properties.collisionRule().key());
            }
            this.writeByte(ColorUtil.getId((NamedTextColor)this.properties.playerColor()));
        }
        if (this.teamMode == WrapperPlayServerTeams.TeamMode.CREATE) {
            if (this.serverVersion == ServerVersion.V_1_7_10) {
                this.writeShort(this.properties.syncedEntries().size());
            } else {
                this.writeVarInt(this.properties.syncedEntries().size());
            }
            for (String string : this.properties.syncedEntries()) {
                this.writeString(string);
            }
        }
    }
}

