/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents;

import me.ulrich.clans.library.packetevents.PacketEvents;
import me.ulrich.clans.library.packetevents.PacketEventsAPI;
import me.ulrich.clans.library.packetevents.manager.server.ServerVersion;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LineRenderingStrategy;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents.ObjectivePacketAdapterImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents.PacketEventsSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents.team.TeamsPacketAdapterImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketAdapterProviderImpl
implements PacketAdapterProvider {
    private final PacketEventsAPI<?> packetEvents = PacketEvents.getAPI();
    private final PacketEventsSender packetSender;

    public PacketAdapterProviderImpl() {
        if (this.packetEvents == null) {
            throw new IllegalStateException("PacketEvents exists in classpath but isn't loaded");
        }
        this.packetSender = new PacketEventsSender(this.packetEvents);
    }

    @Override
    @NotNull
    public TeamsPacketAdapter createTeamPacketAdapter(@NotNull String string) {
        return new TeamsPacketAdapterImpl(this.packetSender, string);
    }

    @Override
    @NotNull
    public ObjectivePacketAdapter createObjectiveAdapter(@NotNull String string) {
        return new ObjectivePacketAdapterImpl(this.packetSender, this.packetEvents, string);
    }

    @Override
    @NotNull
    public LineRenderingStrategy lineRenderingStrategy(@NotNull Player player) {
        ServerVersion serverVersion = this.packetEvents.getServerManager().getVersion();
        return serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? LineRenderingStrategy.MODERN : LineRenderingStrategy.LEGACY;
    }
}

