/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import me.ulrich.clans.library.packetevents.PacketEventsAPI;
import me.ulrich.clans.library.packetevents.manager.server.ServerVersion;
import me.ulrich.clans.library.packetevents.wrapper.PacketWrapper;
import me.ulrich.clans.library.packetevents.wrapper.play.server.WrapperPlayServerDisplayScoreboard;
import me.ulrich.clans.library.packetevents.wrapper.play.server.WrapperPlayServerResetScore;
import me.ulrich.clans.library.packetevents.wrapper.play.server.WrapperPlayServerScoreboardObjective;
import me.ulrich.clans.library.packetevents.wrapper.play.server.WrapperPlayServerUpdateScore;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectiveConstants;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.packetevents.ScoreFormatConverter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.LocalePacketUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectivePacketAdapterImpl
implements ObjectivePacketAdapter {
    private final PacketSender<PacketWrapper<?>> provider;
    private final PacketEventsAPI<?> packetEvents;
    private final String objectiveName;
    private WrapperPlayServerScoreboardObjective removePacket;

    public ObjectivePacketAdapterImpl(@NotNull PacketSender<PacketWrapper<?>> packetSender, @NotNull PacketEventsAPI<?> packetEventsAPI, @NotNull String string) {
        this.provider = packetSender;
        this.packetEvents = packetEventsAPI;
        this.objectiveName = string;
    }

    @Override
    @NotNull
    public String objectiveName() {
        return this.objectiveName;
    }

    @Override
    public void display(@NotNull Collection<Player> collection, @NotNull ObjectiveDisplaySlot objectiveDisplaySlot) {
        WrapperPlayServerDisplayScoreboard wrapperPlayServerDisplayScoreboard = new WrapperPlayServerDisplayScoreboard(ObjectiveConstants.displaySlotIndex(objectiveDisplaySlot), this.objectiveName);
        this.provider.sendPacket((Iterable<Player>)collection, (PacketWrapper<?>)wrapperPlayServerDisplayScoreboard);
    }

    @Override
    public void sendProperties(@NotNull Collection<Player> collection, @NotNull PropertiesPacketType propertiesPacketType, @NotNull Component component, @NotNull ObjectiveRenderType objectiveRenderType, @Nullable ScoreFormat scoreFormat) {
        LocalePacketUtil.sendLocalePackets(this.provider, collection, locale -> this.createObjectivePacket((Locale)locale, propertiesPacketType, component, objectiveRenderType, scoreFormat));
    }

    @Override
    public void remove(@NotNull Collection<Player> collection) {
        if (this.removePacket == null) {
            this.removePacket = new WrapperPlayServerScoreboardObjective(this.objectiveName, WrapperPlayServerScoreboardObjective.ObjectiveMode.REMOVE, null, null);
        }
        this.provider.sendPacket((Iterable<Player>)collection, (PacketWrapper<?>)this.removePacket);
    }

    @Override
    public void sendScore(@NotNull Collection<Player> collection, @NotNull String string, int n2, @Nullable Component component, @Nullable ScoreFormat scoreFormat) {
        LocalePacketUtil.sendLocalePackets(this.provider, collection, locale -> new WrapperPlayServerUpdateScore(string, WrapperPlayServerUpdateScore.Action.CREATE_OR_UPDATE_ITEM, this.objectiveName, n2, component != null ? GlobalTranslator.render(component, locale) : null, ScoreFormatConverter.convert(locale, scoreFormat)));
    }

    @Override
    public void removeScore(@NotNull Collection<Player> collection, @NotNull String string) {
        WrapperPlayServerUpdateScore wrapperPlayServerUpdateScore = new WrapperPlayServerUpdateScore(string, WrapperPlayServerUpdateScore.Action.REMOVE_ITEM, this.objectiveName, Optional.empty());
        WrapperPlayServerResetScore wrapperPlayServerResetScore = new WrapperPlayServerResetScore(string, this.objectiveName);
        if (this.packetEvents.getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.provider.sendPacket((Iterable<Player>)collection, (PacketWrapper<?>)wrapperPlayServerResetScore);
        } else {
            this.provider.sendPacket((Iterable<Player>)collection, (PacketWrapper<?>)wrapperPlayServerUpdateScore);
        }
    }

    private WrapperPlayServerScoreboardObjective createObjectivePacket(@NotNull Locale locale, @NotNull PropertiesPacketType propertiesPacketType, @NotNull Component component, @NotNull ObjectiveRenderType objectiveRenderType, @Nullable ScoreFormat scoreFormat) {
        WrapperPlayServerScoreboardObjective.RenderType renderType;
        WrapperPlayServerScoreboardObjective.ObjectiveMode objectiveMode;
        switch (propertiesPacketType) {
            case CREATE: {
                objectiveMode = WrapperPlayServerScoreboardObjective.ObjectiveMode.CREATE;
                break;
            }
            case UPDATE: {
                objectiveMode = WrapperPlayServerScoreboardObjective.ObjectiveMode.UPDATE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (objectiveRenderType) {
            case INTEGER: {
                renderType = WrapperPlayServerScoreboardObjective.RenderType.INTEGER;
                break;
            }
            case HEARTS: {
                renderType = WrapperPlayServerScoreboardObjective.RenderType.HEARTS;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new WrapperPlayServerScoreboardObjective(this.objectiveName, objectiveMode, GlobalTranslator.render(component, locale), renderType, ScoreFormatConverter.convert(locale, scoreFormat));
    }
}

