/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.team;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LegacyFormatUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamConstants;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class AbstractTeamsPacketAdapterImpl
implements TeamsPacketAdapter {
    protected final PacketSender<Packet<?>> sender;
    protected final ComponentProvider componentProvider;
    protected final String teamName;
    private PacketPlayOutScoreboardTeam removePacket;

    public AbstractTeamsPacketAdapterImpl(@NotNull PacketSender<Packet<?>> packetSender, @NotNull ComponentProvider componentProvider, @NotNull String string) {
        this.sender = packetSender;
        this.componentProvider = componentProvider;
        this.teamName = string;
    }

    public static PacketPlayOutScoreboardTeam createTeamsPacket(int n2, @NotNull String string, @Nullable PacketPlayOutScoreboardTeam.b b2, @Nullable Collection<String> collection) {
        return PacketAccessors.TEAM_PACKET_CONSTRUCTOR.invoke(string, n2, Optional.ofNullable(b2), collection == null ? Collections.emptyList() : collection);
    }

    @Override
    public void removeTeam(@NotNull Iterable<Player> iterable) {
        if (this.removePacket == null) {
            this.removePacket = AbstractTeamsPacketAdapterImpl.createTeamsPacket(1, this.teamName, null, null);
        }
        this.sender.sendPacket(iterable, (Packet<?>)this.removePacket);
    }

    public abstract class TeamDisplayPacketAdapterImpl
    implements TeamDisplayPacketAdapter {
        protected final ImmutableTeamProperties<Component> properties;

        public TeamDisplayPacketAdapterImpl(ImmutableTeamProperties<Component> immutableTeamProperties) {
            this.properties = immutableTeamProperties;
        }

        @Override
        public void sendEntries(@NotNull EntriesPacketType entriesPacketType, @NotNull Collection<Player> collection, @NotNull Collection<String> collection2) {
            AbstractTeamsPacketAdapterImpl.this.sender.sendPacket((Iterable<Player>)collection, (Packet<?>)AbstractTeamsPacketAdapterImpl.createTeamsPacket(TeamConstants.mode(entriesPacketType), AbstractTeamsPacketAdapterImpl.this.teamName, null, collection2));
        }

        protected void fillParameters(@NotNull PacketPlayOutScoreboardTeam.b b2, @UnknownNullability Locale locale) {
            if (PacketAccessors.IS_1_21_5_OR_ABOVE) {
                Objects.requireNonNull(PacketAccessors.NAME_TAG_VISIBILITY_FIELD_1_21_5).set(b2, ScoreboardTeamBase.EnumNameTagVisibility.valueOf((String)this.properties.nameTagVisibility().name()));
                Objects.requireNonNull(PacketAccessors.COLLISION_RULE_FIELD_1_21_5).set(b2, ScoreboardTeamBase.EnumTeamPush.valueOf((String)this.properties.collisionRule().name()));
            } else {
                Objects.requireNonNull(PacketAccessors.NAME_TAG_VISIBILITY_FIELD_1_21_4).set(b2, this.properties.nameTagVisibility().key());
                Objects.requireNonNull(PacketAccessors.COLLISION_RULE_FIELD_1_21_4).set(b2, this.properties.collisionRule().key());
            }
            char c2 = LegacyFormatUtil.getChar(this.properties.playerColor());
            PacketAccessors.COLOR_FIELD.set(b2, EnumChatFormat.a((char)c2));
            int n2 = this.properties.packOptions();
            PacketAccessors.OPTIONS_FIELD.set(b2, n2);
        }
    }
}

