/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.objective;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.Optional;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScoreFormatConverter {
    private static final MethodHandle RESULT_UNWRAP_METHOD;

    private ScoreFormatConverter() {
    }

    @Nullable
    public static Object convert(@NotNull ComponentProvider componentProvider, @Nullable Locale locale, @Nullable ScoreFormat scoreFormat) {
        if (scoreFormat == null || !PacketAccessors.IS_1_20_3_OR_ABOVE) {
            return null;
        }
        if (scoreFormat == ScoreFormat.blank()) {
            return BlankFormat.a;
        }
        if (scoreFormat instanceof ScoreFormat.Styled) {
            ChatModifier chatModifier;
            JsonElement jsonElement = GsonComponentSerializer.gson().serializer().toJsonTree(((ScoreFormat.Styled)scoreFormat).style());
            DataResult dataResult = ChatModifier.ChatModifierSerializer.b.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            try {
                chatModifier = (ChatModifier)RESULT_UNWRAP_METHOD.invokeExact(dataResult).orElseThrow(RuntimeException::new);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return new StyledFormat(chatModifier);
        }
        if (scoreFormat instanceof ScoreFormat.Fixed) {
            return new FixedFormat(componentProvider.fromAdventure(((ScoreFormat.Fixed)scoreFormat).content(), locale));
        }
        throw new IllegalArgumentException("Invalid score format: " + scoreFormat);
    }

    static {
        try {
            RESULT_UNWRAP_METHOD = MethodHandles.lookup().findVirtual(DataResult.class, "result", MethodType.methodType(Optional.class));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

