/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.objective;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.objective.DisplaySlotProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectiveConstants;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.reflect.ReflectUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractObjectivePacketAdapter
implements ObjectivePacketAdapter {
    protected final PacketSender<Packet<?>> sender;
    protected final ComponentProvider componentProvider;
    protected final String objectiveName;
    private PacketPlayOutScoreboardObjective removePacket;

    public AbstractObjectivePacketAdapter(@NotNull PacketSender<Packet<?>> packetSender, @NotNull ComponentProvider componentProvider, @NotNull String string) {
        this.sender = packetSender;
        this.componentProvider = componentProvider;
        this.objectiveName = string;
    }

    @Override
    @NotNull
    public String objectiveName() {
        return this.objectiveName;
    }

    @Override
    public void display(@NotNull Collection<Player> collection, @NotNull ObjectiveDisplaySlot objectiveDisplaySlot) {
        this.sender.sendPacket((Iterable<Player>)collection, (Packet<?>)this.createDisplayPacket(objectiveDisplaySlot));
    }

    @Override
    public void remove(@NotNull Collection<Player> collection) {
        if (this.removePacket == null) {
            this.removePacket = ReflectUtil.getEmptyConstructor(PacketPlayOutScoreboardObjective.class).invoke();
            PacketAccessors.OBJECTIVE_NAME_FIELD.set(this.removePacket, this.objectiveName);
            PacketAccessors.OBJECTIVE_MODE_FIELD.set(this.removePacket, 1);
        }
        this.sender.sendPacket((Iterable<Player>)collection, (Packet<?>)this.removePacket);
    }

    @Override
    public void removeScore(@NotNull Collection<Player> collection, @NotNull String string) {
        Object object = PacketAccessors.IS_1_20_3_OR_ABOVE ? new ClientboundResetScorePacket(string, this.objectiveName) : (Packet)Objects.requireNonNull(PacketAccessors.SCORE_1_20_2_CONSTRUCTOR).invoke(PacketAccessors.SCORE_1_20_2_METHOD_REMOVE, this.objectiveName, string, 0);
        this.sender.sendPacket((Iterable<Player>)collection, (Packet<?>)object);
    }

    @NotNull
    protected PacketPlayOutScoreboardDisplayObjective createDisplayPacket(@NotNull ObjectiveDisplaySlot objectiveDisplaySlot) {
        PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective = PacketAccessors.IS_1_20_2_OR_ABOVE ? new PacketPlayOutScoreboardDisplayObjective(DisplaySlotProvider.toNms(objectiveDisplaySlot), null) : Objects.requireNonNull(PacketAccessors.DISPLAY_1_20_1_CONSTRUCTOR).invoke(ObjectiveConstants.displaySlotIndex(objectiveDisplaySlot), null);
        PacketAccessors.DISPLAY_OBJECTIVE_NAME.set(packetPlayOutScoreboardDisplayObjective, this.objectiveName);
        return packetPlayOutScoreboardDisplayObjective;
    }

    @NotNull
    protected PacketPlayOutScoreboardScore createScorePacket(@NotNull String string, int n2, @Nullable IChatBaseComponent iChatBaseComponent, @Nullable Object object) {
        if (PacketAccessors.IS_1_20_5_OR_ABOVE) {
            return new PacketPlayOutScoreboardScore(string, this.objectiveName, n2, Optional.ofNullable(iChatBaseComponent), Optional.ofNullable((NumberFormat)object));
        }
        if (PacketAccessors.IS_1_20_3_OR_ABOVE) {
            return Objects.requireNonNull(PacketAccessors.SCORE_1_20_3_CONSTRUCTOR).invoke(string, this.objectiveName, n2, iChatBaseComponent, object);
        }
        return Objects.requireNonNull(PacketAccessors.SCORE_1_20_2_CONSTRUCTOR).invoke(PacketAccessors.SCORE_1_20_2_METHOD_CHANGE, this.objectiveName, string, n2);
    }

    @NotNull
    protected PacketPlayOutScoreboardObjective createObjectivePacket(@NotNull PropertiesPacketType propertiesPacketType, @NotNull IChatBaseComponent iChatBaseComponent, @NotNull ObjectiveRenderType objectiveRenderType, @Nullable Object enumScoreboardHealthDisplay) {
        IScoreboardCriteria.EnumScoreboardHealthDisplay enumScoreboardHealthDisplay2;
        PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = PacketAccessors.OBJECTIVE_PACKET_CONSTRUCTOR.invoke();
        PacketAccessors.OBJECTIVE_MODE_FIELD.set(packetPlayOutScoreboardObjective, ObjectiveConstants.mode(propertiesPacketType));
        PacketAccessors.OBJECTIVE_NAME_FIELD.set(packetPlayOutScoreboardObjective, this.objectiveName);
        PacketAccessors.OBJECTIVE_VALUE_FIELD.set(packetPlayOutScoreboardObjective, iChatBaseComponent);
        if (PacketAccessors.IS_1_20_3_OR_ABOVE) {
            assert (PacketAccessors.OBJECTIVE_NUMBER_FORMAT_FIELD != null);
            enumScoreboardHealthDisplay2 = PacketAccessors.IS_1_20_5_OR_ABOVE ? Optional.ofNullable(enumScoreboardHealthDisplay) : enumScoreboardHealthDisplay;
            PacketAccessors.OBJECTIVE_NUMBER_FORMAT_FIELD.set(packetPlayOutScoreboardObjective, enumScoreboardHealthDisplay2);
        }
        switch (objectiveRenderType) {
            case INTEGER: {
                enumScoreboardHealthDisplay2 = IScoreboardCriteria.EnumScoreboardHealthDisplay.a;
                break;
            }
            case HEARTS: {
                enumScoreboardHealthDisplay2 = IScoreboardCriteria.EnumScoreboardHealthDisplay.b;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        PacketAccessors.OBJECTIVE_RENDER_TYPE_FIELD.set(packetPlayOutScoreboardObjective, enumScoreboardHealthDisplay2);
        return packetPlayOutScoreboardObjective;
    }
}

