/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern;

import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LineRenderingStrategy;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProviderImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.objective.PaperObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.objective.SpigotObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.team.PaperTeamsPacketAdapterImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.team.SpigotTeamsPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.util.PacketUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import net.minecraft.network.protocol.Packet;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketAdapterProviderImpl
implements PacketAdapterProvider,
PacketSender<Packet<?>> {
    private boolean isNativeAdventure;
    private final ComponentProvider componentProvider;

    public PacketAdapterProviderImpl() {
        try {
            Class.forName("io.papermc.paper.adventure.PaperAdventure");
            String string = "net.ky".concat("ori.adventure.text");
            if (Component.class.getPackage().getName().equals(string)) {
                this.isNativeAdventure = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.componentProvider = new ComponentProviderImpl(this.isNativeAdventure);
    }

    @Override
    @NotNull
    public ObjectivePacketAdapter createObjectiveAdapter(@NotNull String string) {
        return this.isNativeAdventure ? new PaperObjectivePacketAdapter(this, this.componentProvider, string) : new SpigotObjectivePacketAdapter(this, this.componentProvider, string);
    }

    @Override
    @NotNull
    public TeamsPacketAdapter createTeamPacketAdapter(@NotNull String string) {
        return this.isNativeAdventure ? new PaperTeamsPacketAdapterImpl(this, this.componentProvider, string) : new SpigotTeamsPacketAdapter(this, this.componentProvider, string);
    }

    @Override
    @NotNull
    public LineRenderingStrategy lineRenderingStrategy(@NotNull Player player) {
        return LineRenderingStrategy.MODERN;
    }

    @Override
    public void sendPacket(@NotNull Player player, @NotNull Packet<?> packet) {
        PacketUtil.sendPacket(player, packet);
    }
}

