/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Locale;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.util.NativeAdventureUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.modern.util.RegistryUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.reflect.ReflectUtil;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentProviderImpl
implements ComponentProvider {
    private static final MethodHandle FROM_JSON_METHOD;
    private final boolean isNativeAdventure;

    public ComponentProviderImpl(boolean bl) {
        this.isNativeAdventure = bl;
    }

    @Override
    public @NotNull IChatBaseComponent fromAdventure(@NotNull Component component, @Nullable Locale locale) {
        if (this.isNativeAdventure) {
            return NativeAdventureUtil.fromAdventureComponent(component);
        }
        Component component2 = component;
        if (locale != null) {
            component2 = GlobalTranslator.render(component, locale);
        }
        JsonElement jsonElement = GsonComponentSerializer.gson().serializeToTree(component2);
        if (FROM_JSON_METHOD == null) {
            return (IChatBaseComponent)ComponentSerialization.a.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
        }
        Object[] objectArray = PacketAccessors.IS_1_20_5_OR_ABOVE ? new Object[]{jsonElement, RegistryUtil.MINECRAFT_REGISTRY} : new Object[]{jsonElement};
        try {
            return (IChatBaseComponent)FROM_JSON_METHOD.invokeWithArguments(objectArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        if (!PacketAccessors.IS_1_21_6_OR_ABOVE) {
            Class<?> clazz = ReflectUtil.getClassOrThrow("net.minecraft.network.chat.Component$Serializer", "net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
            MethodHandle methodHandle = null;
            for (Method method : clazz.getMethods()) {
                if (method.getReturnType() != IChatMutableComponent.class || method.getParameterCount() < 1 || method.getParameterCount() > 2 || method.getParameterTypes()[0] != JsonElement.class) continue;
                try {
                    methodHandle = MethodHandles.lookup().unreflect(method);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ExceptionInInitializerError(illegalAccessException);
                }
            }
            if (methodHandle == null) {
                throw new ExceptionInInitializerError("failed to find chat component fromJson method");
            }
            FROM_JSON_METHOD = methodHandle;
        } else {
            FROM_JSON_METHOD = null;
        }
    }
}

