/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Locale;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LegacyFormatUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy.ChatColorUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy.LegacyPacketSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy.PacketAccessors;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamConstants;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.team.TeamsPacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.LocalePacketUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TeamsPacketAdapterImpl
implements TeamsPacketAdapter {
    private final String teamName;
    private Object removePacket;

    public TeamsPacketAdapterImpl(@NotNull String string) {
        this.teamName = string;
    }

    @Override
    public void removeTeam(@NotNull Iterable<Player> iterable) {
        if (this.removePacket == null) {
            this.removePacket = PacketAccessors.TEAM_CONSTRUCTOR.invoke(new Object[0]);
            PacketAccessors.TEAM_NAME_FIELD.set(this.removePacket, this.teamName);
            PacketAccessors.TEAM_MODE_FIELD.set(this.removePacket, 1);
        }
        LegacyPacketSender.INSTANCE.sendPacket(iterable, this.removePacket);
    }

    @Override
    @NotNull
    public TeamDisplayPacketAdapter createTeamDisplayAdapter(@NotNull ImmutableTeamProperties<Component> immutableTeamProperties) {
        return new AdventureTeamDisplayPacketAdapter(immutableTeamProperties);
    }

    @Override
    @NotNull
    public TeamDisplayPacketAdapter createLegacyTeamDisplayAdapter(@NotNull ImmutableTeamProperties<String> immutableTeamProperties) {
        return new LegacyTeamDisplayPacketAdapter(immutableTeamProperties);
    }

    private class AdventureTeamDisplayPacketAdapter
    extends AbstractTeamDisplayPacketAdapter<Component> {
        public AdventureTeamDisplayPacketAdapter(ImmutableTeamProperties<Component> immutableTeamProperties) {
            super(immutableTeamProperties);
        }

        @Override
        @NotNull
        protected String toLegacy(@NotNull Component component, @NotNull Locale locale) {
            return LegacyFormatUtil.serialize(component, locale);
        }
    }

    private class LegacyTeamDisplayPacketAdapter
    extends AbstractTeamDisplayPacketAdapter<String> {
        public LegacyTeamDisplayPacketAdapter(ImmutableTeamProperties<String> immutableTeamProperties) {
            super(immutableTeamProperties);
        }

        @Override
        @NotNull
        protected String toLegacy(@NotNull String string, @NotNull Locale locale) {
            return string;
        }
    }

    private abstract class AbstractTeamDisplayPacketAdapter<C>
    implements TeamDisplayPacketAdapter {
        protected final ImmutableTeamProperties<C> properties;

        public AbstractTeamDisplayPacketAdapter(ImmutableTeamProperties<C> immutableTeamProperties) {
            this.properties = immutableTeamProperties;
        }

        @Override
        public void sendEntries(@NotNull EntriesPacketType entriesPacketType, @NotNull Collection<Player> collection, @NotNull Collection<String> collection2) {
            Object obj = PacketAccessors.TEAM_CONSTRUCTOR.invoke(new Object[0]);
            PacketAccessors.TEAM_NAME_FIELD.set(obj, TeamsPacketAdapterImpl.this.teamName);
            PacketAccessors.TEAM_MODE_FIELD.set(obj, TeamConstants.mode(entriesPacketType));
            PacketAccessors.TEAM_ENTRIES_FIELD.set(obj, collection2);
            LegacyPacketSender.INSTANCE.sendPacket(collection, obj);
        }

        @Override
        public void sendProperties(@NotNull PropertiesPacketType propertiesPacketType, @NotNull Collection<Player> collection) {
            LocalePacketUtil.sendLocalePackets(LegacyPacketSender.INSTANCE, collection, locale -> {
                String string = LegacyFormatUtil.limitLegacyText(this.toLegacy(this.properties.displayName(), (Locale)locale), 16);
                String string2 = LegacyFormatUtil.limitLegacyText(this.toLegacy(this.properties.prefix(), (Locale)locale), 16);
                String string3 = LegacyFormatUtil.limitLegacyText(this.toLegacy(this.properties.suffix(), (Locale)locale), 16);
                Object obj = PacketAccessors.TEAM_CONSTRUCTOR.invoke(new Object[0]);
                PacketAccessors.TEAM_NAME_FIELD.set(obj, TeamsPacketAdapterImpl.this.teamName);
                PacketAccessors.TEAM_MODE_FIELD.set(obj, TeamConstants.mode(propertiesPacketType));
                PacketAccessors.TEAM_DISPLAY_NAME_FIELD.set(obj, string);
                PacketAccessors.TEAM_PREFIX_FIELD.set(obj, string2);
                PacketAccessors.TEAM_SUFFIX_FIELD.set(obj, string3);
                PacketAccessors.TEAM_RULES_FIELD.set(obj, this.properties.packOptions());
                if (PacketAccessors.TEAM_NAME_TAG_VISIBILITY_FIELD != null) {
                    PacketAccessors.TEAM_NAME_TAG_VISIBILITY_FIELD.set(obj, this.properties.nameTagVisibility().key());
                }
                NamedTextColor namedTextColor = this.properties.playerColor();
                if (PacketAccessors.TEAM_COLOR_FIELD != null && namedTextColor != null) {
                    int n2 = ChatColorUtil.getColorIndex(namedTextColor);
                    PacketAccessors.TEAM_COLOR_FIELD.set(obj, n2);
                }
                if (PacketAccessors.TEAM_COLLISION_RULE_FIELD != null) {
                    PacketAccessors.TEAM_COLLISION_RULE_FIELD.set(obj, this.properties.collisionRule().key());
                }
                if (propertiesPacketType == PropertiesPacketType.CREATE) {
                    PacketAccessors.TEAM_ENTRIES_FIELD.set(obj, (Collection)ImmutableList.copyOf(this.properties.syncedEntries()));
                }
                return obj;
            });
        }

        @NotNull
        protected abstract String toLegacy(@NotNull C var1, @NotNull Locale var2);
    }
}

