/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy;

import java.util.Collection;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.LegacyFormatUtil;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy.LegacyPacketSender;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.legacy.PacketAccessors;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectiveConstants;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.util.LocalePacketUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectivePacketAdapterImpl
implements ObjectivePacketAdapter {
    private final String objectiveName;
    private Object removePacket;

    public ObjectivePacketAdapterImpl(@NotNull String string) {
        this.objectiveName = string;
    }

    @Override
    @NotNull
    public String objectiveName() {
        return this.objectiveName;
    }

    @Override
    public void display(@NotNull Collection<Player> collection, @NotNull ObjectiveDisplaySlot objectiveDisplaySlot) {
        Object obj = PacketAccessors.DISPLAY_OBJECTIVE_CONSTRUCTOR.invoke(new Object[0]);
        PacketAccessors.DISPLAY_OBJECTIVE_POSITION.set(obj, ObjectiveConstants.displaySlotIndex(objectiveDisplaySlot, false));
        PacketAccessors.DISPLAY_OBJECTIVE_NAME.set(obj, this.objectiveName);
        LegacyPacketSender.INSTANCE.sendPacket(collection, obj);
    }

    @Override
    public void sendProperties(@NotNull Collection<Player> collection, @NotNull PropertiesPacketType propertiesPacketType, @NotNull Component component, @NotNull ObjectiveRenderType objectiveRenderType, @Nullable ScoreFormat scoreFormat) {
        LocalePacketUtil.sendLocalePackets(LegacyPacketSender.INSTANCE, collection, locale -> this.createPropertiesPacket(propertiesPacketType, GlobalTranslator.render(component, locale), objectiveRenderType));
    }

    @Override
    public void remove(@NotNull Collection<Player> collection) {
        if (this.removePacket == null) {
            this.removePacket = PacketAccessors.OBJECTIVE_CONSTRUCTOR.invoke(new Object[0]);
            PacketAccessors.OBJECTIVE_NAME_FIELD.set(this.removePacket, this.objectiveName);
            PacketAccessors.OBJECTIVE_DISPLAY_NAME_FIELD.set(this.removePacket, "");
            PacketAccessors.OBJECTIVE_MODE_FIELD.set(this.removePacket, 1);
        }
        LegacyPacketSender.INSTANCE.sendPacket(collection, this.removePacket);
    }

    @Override
    public void sendScore(@NotNull Collection<Player> collection, @NotNull String string, int n2, @Nullable Component component, @Nullable ScoreFormat scoreFormat) {
        Object obj = PacketAccessors.SCORE_CONSTRUCTOR.invoke(string);
        PacketAccessors.SCORE_OBJECTIVE_NAME_FIELD.set(obj, this.objectiveName);
        PacketAccessors.SCORE_VALUE_FIELD.set(obj, n2);
        if (PacketAccessors.SCORE_ACTION_FIELD_1_8 != null) {
            PacketAccessors.SCORE_ACTION_FIELD_1_8.set(obj, PacketAccessors.SCORE_ACTION_CHANGE_1_8);
        } else {
            PacketAccessors.SCORE_ACTION_FIELD_1_7.set(obj, 0);
        }
        LegacyPacketSender.INSTANCE.sendPacket(collection, obj);
    }

    @Override
    public void removeScore(@NotNull Collection<Player> collection, @NotNull String string) {
        Object obj = PacketAccessors.SCORE_CONSTRUCTOR.invoke(string);
        PacketAccessors.SCORE_OBJECTIVE_NAME_FIELD.set(obj, this.objectiveName);
        LegacyPacketSender.INSTANCE.sendPacket(collection, obj);
    }

    @NotNull
    private Object createPropertiesPacket(@NotNull PropertiesPacketType propertiesPacketType, @NotNull Component component, @NotNull ObjectiveRenderType objectiveRenderType) {
        Object obj = PacketAccessors.OBJECTIVE_CONSTRUCTOR.invoke(new Object[0]);
        PacketAccessors.OBJECTIVE_NAME_FIELD.set(obj, this.objectiveName);
        PacketAccessors.OBJECTIVE_MODE_FIELD.set(obj, ObjectiveConstants.mode(propertiesPacketType));
        String string = LegacyFormatUtil.limitLegacyText(LegacyComponentSerializer.legacySection().serialize(component), 32);
        PacketAccessors.OBJECTIVE_DISPLAY_NAME_FIELD.set(obj, string);
        if (PacketAccessors.OBJECTIVE_HEALTH_DISPLAY_FIELD != null) {
            Object object;
            switch (objectiveRenderType) {
                case INTEGER: {
                    object = PacketAccessors.HEALTH_DISPLAY_INTEGER;
                    break;
                }
                case HEARTS: {
                    object = PacketAccessors.HEALTH_DISPLAY_HEARTS;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            PacketAccessors.OBJECTIVE_HEALTH_DISPLAY_FIELD.set(obj, object);
        }
        return obj;
    }
}

