/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.objective;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveScore;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreboardObjective;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardObjectiveImpl
implements ScoreboardObjective {
    private final ObjectivePacketAdapter packetAdapter;
    private final Queue<ObjectiveManagerTask> taskQueue;
    private final String name;
    private final Map<String, ObjectiveScore> scores = new HashMap<String, ObjectiveScore>();
    private Component value = Component.empty();
    private ObjectiveRenderType renderType = ObjectiveRenderType.INTEGER;
    private ScoreFormat defaultScoreFormat;
    private boolean closed;

    public ScoreboardObjectiveImpl(@NotNull ObjectivePacketAdapter objectivePacketAdapter, @NotNull Queue<ObjectiveManagerTask> queue, @NotNull String string) {
        this.packetAdapter = objectivePacketAdapter;
        this.taskQueue = queue;
        this.name = string;
    }

    public ObjectivePacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Map<String, ObjectiveScore> scores() {
        return this.scores;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public void close() {
        this.closed = true;
    }

    @Override
    @NotNull
    public Component value() {
        return this.value;
    }

    @Override
    @NotNull
    public ScoreboardObjective value(@NotNull ComponentLike componentLike) {
        Component component = componentLike.asComponent();
        if (!this.value.equals(component)) {
            this.value = component;
            if (!this.closed) {
                this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ObjectiveRenderType renderType() {
        return this.renderType;
    }

    @Override
    @NotNull
    public ScoreboardObjective renderType(@NotNull ObjectiveRenderType objectiveRenderType) {
        if (this.renderType != objectiveRenderType) {
            this.renderType = objectiveRenderType;
            if (!this.closed) {
                this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
            }
        }
        return this;
    }

    @Override
    @Nullable
    public ScoreFormat defaultScoreFormat() {
        return this.defaultScoreFormat;
    }

    @Override
    public void defaultScoreFormat(@Nullable ScoreFormat scoreFormat) {
        if (!Objects.equals(this.defaultScoreFormat, scoreFormat)) {
            this.defaultScoreFormat = scoreFormat;
            this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
        }
    }

    @Override
    public void refreshProperties() {
        if (!this.closed) {
            this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
        }
    }

    @Override
    @Nullable
    public ObjectiveScore scoreInfo(@NotNull String string) {
        return this.scores.get(string);
    }

    @Override
    @NotNull
    public ScoreboardObjective score(@NotNull String string, ObjectiveScore objectiveScore) {
        ObjectiveScore objectiveScore2 = this.scores.put(string, objectiveScore);
        if (!Objects.equals(objectiveScore2, objectiveScore)) {
            this.taskQueue.add(new ObjectiveManagerTask.UpdateScore(this, string, objectiveScore));
        }
        return this;
    }

    @Override
    @NotNull
    public ScoreboardObjective removeScore(@NotNull String string) {
        if (this.scores.remove(string) != null) {
            this.taskQueue.add(new ObjectiveManagerTask.UpdateScore(this, string, null));
        }
        return this;
    }

    @Override
    public void refreshScore(@NotNull String string) {
        ObjectiveScore objectiveScore = this.scores.get(string);
        if (objectiveScore != null) {
            this.taskQueue.add(new ObjectiveManagerTask.UpdateScore(this, string, objectiveScore));
        }
    }

    public void sendProperties(@NotNull Collection<Player> collection, @NotNull PropertiesPacketType propertiesPacketType) {
        this.packetAdapter.sendProperties(collection, propertiesPacketType, this.value, this.renderType, this.defaultScoreFormat);
    }
}

