/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.objective;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveManager;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveScore;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreboardObjective;
import me.ulrich.clans.library.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ScoreboardObjectiveImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.PlayerDisplayable;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ObjectiveManagerImpl
implements ObjectiveManager,
PlayerDisplayable {
    private final ScoreboardLibraryImpl library;
    private final Map<String, ScoreboardObjectiveImpl> objectives = new ConcurrentHashMap<String, ScoreboardObjectiveImpl>();
    private final Map<ObjectiveDisplaySlot, ScoreboardObjectiveImpl> displaySlots = new HashMap<ObjectiveDisplaySlot, ScoreboardObjectiveImpl>();
    private final Set<Player> players = CollectionProvider.set(8);
    private final Set<Player> displayingPlayers = CollectionProvider.set(8);
    private final Queue<ObjectiveManagerTask> taskQueue = new ConcurrentLinkedQueue<ObjectiveManagerTask>();
    private boolean closed;

    public ObjectiveManagerImpl(@NotNull ScoreboardLibraryImpl scoreboardLibraryImpl) {
        this.library = scoreboardLibraryImpl;
    }

    @NotNull
    public Queue<ObjectiveManagerTask> taskQueue() {
        return this.taskQueue;
    }

    @Override
    @NotNull
    public ScoreboardObjective create(@NotNull String string) {
        Preconditions.checkNotNull((Object)string);
        this.checkClosed();
        return this.objectives.computeIfAbsent(string, string2 -> {
            ObjectivePacketAdapter objectivePacketAdapter = this.library.packetAdapter().createObjectiveAdapter(string);
            ScoreboardObjectiveImpl scoreboardObjectiveImpl = new ScoreboardObjectiveImpl(objectivePacketAdapter, this.taskQueue, string);
            this.taskQueue.add(new ObjectiveManagerTask.AddObjective(scoreboardObjectiveImpl));
            return scoreboardObjectiveImpl;
        });
    }

    @Override
    public void remove(@NotNull ScoreboardObjective scoreboardObjective) {
        Preconditions.checkNotNull((Object)scoreboardObjective);
        this.checkClosed();
        if (!(scoreboardObjective instanceof ScoreboardObjectiveImpl)) {
            return;
        }
        ScoreboardObjectiveImpl scoreboardObjectiveImpl = (ScoreboardObjectiveImpl)scoreboardObjective;
        if (this.objectives.values().remove(scoreboardObjectiveImpl)) {
            this.displaySlots.values().removeIf(scoreboardObjectiveImpl2 -> scoreboardObjectiveImpl2 == scoreboardObjectiveImpl);
            scoreboardObjectiveImpl.close();
            this.taskQueue.add(new ObjectiveManagerTask.RemoveObjective(scoreboardObjectiveImpl));
        }
    }

    @Override
    public void display(@NotNull ObjectiveDisplaySlot objectiveDisplaySlot, @NotNull ScoreboardObjective scoreboardObjective) {
        Preconditions.checkNotNull((Object)objectiveDisplaySlot);
        Preconditions.checkNotNull((Object)scoreboardObjective);
        this.checkClosed();
        if (!(scoreboardObjective instanceof ScoreboardObjectiveImpl)) {
            throw new IllegalArgumentException("Invalid objective implementation");
        }
        ScoreboardObjectiveImpl scoreboardObjectiveImpl = (ScoreboardObjectiveImpl)scoreboardObjective;
        if (this.objectives.get(scoreboardObjectiveImpl.name()) != scoreboardObjectiveImpl) {
            throw new IllegalArgumentException("Objective is from a different manager");
        }
        this.displaySlots.put(objectiveDisplaySlot, scoreboardObjectiveImpl);
        this.taskQueue.add(new ObjectiveManagerTask.UpdateDisplaySlot(objectiveDisplaySlot, scoreboardObjectiveImpl));
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.add(player)) {
            return false;
        }
        this.taskQueue.add(new ObjectiveManagerTask.AddPlayer(player));
        return true;
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.remove(player)) {
            return false;
        }
        this.taskQueue.add(new ObjectiveManagerTask.RemovePlayer(player));
        return true;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.add(ObjectiveManagerTask.Close.INSTANCE);
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    public boolean tick() {
        ObjectiveManagerTask objectiveManagerTask;
        while ((objectiveManagerTask = this.taskQueue.poll()) != null) {
            Object object;
            Object object2;
            if (objectiveManagerTask instanceof ObjectiveManagerTask.Close) {
                for (ScoreboardObjectiveImpl scoreboardObjectiveImpl : this.objectives.values()) {
                    scoreboardObjectiveImpl.packetAdapter().remove(this.displayingPlayers);
                }
                for (Player player : this.players) {
                    Objects.requireNonNull(this.library.getPlayer(player)).objectiveManagerQueue().remove(this);
                }
                return false;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.AddPlayer) {
                object2 = ((ObjectiveManagerTask.AddPlayer)objectiveManagerTask).player();
                @NotNull ScoreboardLibraryPlayer scoreboardLibraryPlayer = this.library.getOrCreatePlayer((Player)object2);
                scoreboardLibraryPlayer.objectiveManagerQueue().add(this);
                continue;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.RemovePlayer) {
                object2 = ((ObjectiveManagerTask.RemovePlayer)objectiveManagerTask).player();
                Set<Player> set = Collections.singleton(object2);
                for (ScoreboardObjectiveImpl scoreboardObjectiveImpl : this.objectives.values()) {
                    scoreboardObjectiveImpl.packetAdapter().remove(set);
                }
                this.displayingPlayers.remove(object2);
                Objects.requireNonNull(this.library.getPlayer((Player)object2)).objectiveManagerQueue().remove(this);
                continue;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.ReloadPlayer) {
                object2 = ((ObjectiveManagerTask.ReloadPlayer)objectiveManagerTask).player();
                Set<Object> set = Collections.singleton(object2);
                for (ScoreboardObjectiveImpl scoreboardObjectiveImpl : this.objectives.values()) {
                    scoreboardObjectiveImpl.sendProperties(set, PropertiesPacketType.UPDATE);
                    for (Map.Entry<String, ObjectiveScore> entry : scoreboardObjectiveImpl.scores().entrySet()) {
                        ObjectiveScore objectiveScore = entry.getValue();
                        scoreboardObjectiveImpl.packetAdapter().sendScore(set, entry.getKey(), objectiveScore.value(), objectiveScore.displayName(), objectiveScore.format());
                    }
                }
                continue;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.AddObjective) {
                object2 = ((ObjectiveManagerTask.AddObjective)objectiveManagerTask).objective();
                ((ScoreboardObjectiveImpl)object2).sendProperties(this.displayingPlayers, PropertiesPacketType.CREATE);
                continue;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.RemoveObjective) {
                object2 = ((ObjectiveManagerTask.RemoveObjective)objectiveManagerTask).objective();
                ((ScoreboardObjectiveImpl)object2).packetAdapter().remove(this.displayingPlayers);
                continue;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.UpdateObjective) {
                object2 = ((ObjectiveManagerTask.UpdateObjective)objectiveManagerTask).objective();
                ((ScoreboardObjectiveImpl)object2).sendProperties(this.displayingPlayers, PropertiesPacketType.UPDATE);
                continue;
            }
            if (objectiveManagerTask instanceof ObjectiveManagerTask.UpdateScore) {
                object2 = (ObjectiveManagerTask.UpdateScore)objectiveManagerTask;
                ScoreboardObjectiveImpl scoreboardObjectiveImpl = ((ObjectiveManagerTask.UpdateScore)object2).objective();
                object = ((ObjectiveManagerTask.UpdateScore)object2).entry();
                ObjectiveScore objectiveScore = ((ObjectiveManagerTask.UpdateScore)object2).score();
                if (objectiveScore != null) {
                    scoreboardObjectiveImpl.packetAdapter().sendScore(this.displayingPlayers, (String)object, objectiveScore.value(), objectiveScore.displayName(), objectiveScore.format());
                    continue;
                }
                scoreboardObjectiveImpl.packetAdapter().removeScore(this.displayingPlayers, (String)object);
                continue;
            }
            if (!(objectiveManagerTask instanceof ObjectiveManagerTask.UpdateDisplaySlot)) continue;
            object2 = (ObjectiveManagerTask.UpdateDisplaySlot)objectiveManagerTask;
            ObjectiveDisplaySlot objectiveDisplaySlot = ((ObjectiveManagerTask.UpdateDisplaySlot)object2).displaySlot();
            object = ((ObjectiveManagerTask.UpdateDisplaySlot)object2).objective();
            ((ScoreboardObjectiveImpl)object).packetAdapter().display(this.displayingPlayers, objectiveDisplaySlot);
        }
        return true;
    }

    @Override
    public void display(@NotNull Player player) {
        this.displayingPlayers.add(player);
        Set<Player> set = Collections.singleton(player);
        for (ScoreboardObjectiveImpl object : this.objectives.values()) {
            object.sendProperties(set, PropertiesPacketType.CREATE);
            for (Map.Entry<String, ObjectiveScore> entry : object.scores().entrySet()) {
                ObjectiveScore objectiveScore = entry.getValue();
                object.packetAdapter().sendScore(set, entry.getKey(), objectiveScore.value(), objectiveScore.displayName(), objectiveScore.format());
            }
        }
        for (Map.Entry entry : this.displaySlots.entrySet()) {
            ((ScoreboardObjectiveImpl)entry.getValue()).packetAdapter().display(set, (ObjectiveDisplaySlot)entry.getKey());
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ObjectiveManager is closed");
        }
    }
}

