/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.commons;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.ulrich.clans.library.kyori.adventure.text.serializer.legacy.LegacyFormat;
import me.ulrich.clans.library.kyori.adventure.translation.GlobalTranslator;
import me.ulrich.clans.library.scoreboardlibrary.implementation.commons.CollectionProvider;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public final class LegacyFormatUtil {
    private static final Map<NamedTextColor, Character> legacyMap;

    private LegacyFormatUtil() {
    }

    public static String limitLegacyText(String string, int n2) {
        if (string.length() <= n2) {
            return string;
        }
        int n3 = n2 - 1;
        while (string.charAt(n3) == '\u00a7') {
            --n3;
        }
        return string.substring(0, n3 + 1);
    }

    public static String serialize(@Nullable Component component, @Nullable Locale locale) {
        if (component == null || component == Component.empty()) {
            return "";
        }
        Component component2 = locale != null ? GlobalTranslator.render(component, locale) : component;
        return LegacyComponentSerializer.legacySection().serialize(component2);
    }

    public static char getChar(@Nullable NamedTextColor namedTextColor) {
        if (namedTextColor == null) {
            return 'r';
        }
        return legacyMap.getOrDefault(namedTextColor, Character.valueOf('\u0000')).charValue();
    }

    static {
        ChatColor[] chatColorArray = ChatColor.values();
        legacyMap = CollectionProvider.map(chatColorArray.length);
        for (ChatColor chatColor : chatColorArray) {
            if (!chatColor.isColor()) continue;
            char c2 = chatColor.getChar();
            LegacyFormat legacyFormat = Objects.requireNonNull(LegacyComponentSerializer.parseChar(c2));
            legacyMap.put((NamedTextColor)legacyFormat.color(), Character.valueOf(c2));
        }
    }
}

