/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation.commons;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CollectionProvider {
    private static final MethodHandle mapConstructor;
    private static final MethodHandle setConstructor;
    private static final MethodHandle listConstructor;

    private CollectionProvider() {
    }

    private static MethodHandle getConstructor(MethodHandles.Lookup lookup, String string, Class<?> clazz, MethodType methodType) {
        Class<?> clazz2;
        try {
            clazz2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz2 = clazz;
        }
        try {
            return lookup.findConstructor(clazz2, methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }

    @NotNull
    public static <K, V> Map<K, V> map(int n2) {
        try {
            return (Map)mapConstructor.invokeWithArguments(n2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @NotNull
    public static <E> Set<E> set(int n2) {
        try {
            return (Set)setConstructor.invokeWithArguments(n2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @NotNull
    public static <E> List<E> list(int n2) {
        try {
            return (List)listConstructor.invokeWithArguments(n2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType methodType = MethodType.methodType(Void.TYPE, Integer.TYPE);
        mapConstructor = CollectionProvider.getConstructor(lookup, "it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap", HashMap.class, methodType);
        setConstructor = CollectionProvider.getConstructor(lookup, "it.unimi.dsi.fastutil.objects.ObjectOpenHashSet", HashSet.class, methodType);
        listConstructor = CollectionProvider.getConstructor(lookup, "it.unimi.dsi.fastutil.objects.ObjectArrayList", ArrayList.class, methodType);
    }
}

