/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.ulrich.clans.library.scoreboardlibrary.api.ScoreboardLibrary;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveManager;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.Sidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.PacketAdapterLoader;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ObjectiveManagerImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.objective.ObjectiveUpdaterTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.LocaleListener;
import me.ulrich.clans.library.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import me.ulrich.clans.library.scoreboardlibrary.implementation.scheduler.TaskScheduler;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.PlayerDependantLocaleSidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.SidebarUpdaterTask;
import me.ulrich.clans.library.scoreboardlibrary.implementation.sidebar.SingleLocaleSidebar;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamManagerImpl;
import me.ulrich.clans.library.scoreboardlibrary.implementation.team.TeamUpdaterTask;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardLibraryImpl
implements ScoreboardLibrary {
    private final Plugin plugin;
    private final PacketAdapterProvider packetAdapter;
    private final TaskScheduler taskScheduler;
    private final Map<Player, ScoreboardLibraryPlayer> playerMap = new MapMaker().weakKeys().makeMap();
    private volatile Set<TeamManagerImpl> teamManagers;
    private volatile Set<ObjectiveManagerImpl> objectiveManagers;
    private volatile Set<AbstractSidebar> sidebars;
    private final LocaleListener localeListener;
    private TeamUpdaterTask teamTask;
    private ObjectiveUpdaterTask objectiveTask;
    private SidebarUpdaterTask sidebarTask;
    private final Object lock = new Object();
    private volatile boolean closed;

    public ScoreboardLibraryImpl(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        try {
            Class.forName("me.ulrich.clans.library.kyori.adventure.Adventure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Adventure is not in the classpath");
        }
        this.plugin = plugin;
        this.packetAdapter = PacketAdapterLoader.loadPacketAdapter();
        this.taskScheduler = TaskScheduler.create(plugin);
        boolean bl = false;
        try {
            Class.forName("org.bukkit.event.player.PlayerLocaleChangeEvent");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (bl) {
            this.localeListener = new LocaleListener(this);
            plugin.getServer().getPluginManager().registerEvents((Listener)this.localeListener, plugin);
        } else {
            this.localeListener = null;
        }
    }

    @NotNull
    public Plugin plugin() {
        return this.plugin;
    }

    @NotNull
    public PacketAdapterProvider packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public TaskScheduler taskScheduler() {
        return this.taskScheduler;
    }

    @Override
    @NotNull
    public Sidebar createSidebar(int n2, @Nullable Locale locale, @NotNull String string) {
        this.checkClosed();
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid maxLines value: " + n2);
        }
        AbstractSidebar abstractSidebar = locale == null ? new PlayerDependantLocaleSidebar(this, n2, string) : new SingleLocaleSidebar(this, n2, string, locale);
        this.sidebars().add(abstractSidebar);
        return abstractSidebar;
    }

    @Override
    @NotNull
    public TeamManagerImpl createTeamManager() {
        this.checkClosed();
        TeamManagerImpl teamManagerImpl = new TeamManagerImpl(this);
        this.teamManagers().add(teamManagerImpl);
        return teamManagerImpl;
    }

    @Override
    @NotNull
    public ObjectiveManager createObjectiveManager() {
        this.checkClosed();
        ObjectiveManagerImpl objectiveManagerImpl = new ObjectiveManagerImpl(this);
        this.objectiveManagers().add(objectiveManagerImpl);
        return objectiveManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        HandlerList.unregisterAll((Listener)this.localeListener);
        if (this.teamManagers != null) {
            this.teamTask.task().cancel();
            object = this.teamTask.lock();
            synchronized (object) {
                for (TeamManagerImpl playerDisplayable : this.teamManagers) {
                    playerDisplayable.close();
                    playerDisplayable.tick();
                }
            }
        }
        if (this.objectiveManagers != null) {
            this.objectiveTask.task().cancel();
            object = this.objectiveTask.lock();
            synchronized (object) {
                for (ObjectiveManagerImpl objectiveManagerImpl : this.objectiveManagers) {
                    objectiveManagerImpl.close();
                    objectiveManagerImpl.tick();
                }
            }
        }
        if (this.sidebars != null) {
            this.sidebarTask.task().cancel();
            object = this.sidebarTask.lock();
            synchronized (object) {
                for (AbstractSidebar abstractSidebar : this.sidebars) {
                    abstractSidebar.close();
                    abstractSidebar.tick();
                }
            }
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TeamManagerImpl> teamManagers() {
        if (this.teamManagers == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.teamManagers == null) {
                    this.teamManagers = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
                    this.teamTask = new TeamUpdaterTask(this);
                }
            }
        }
        return this.teamManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectiveManagerImpl> objectiveManagers() {
        if (this.objectiveManagers == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.objectiveManagers == null) {
                    this.objectiveManagers = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
                    this.objectiveTask = new ObjectiveUpdaterTask(this);
                }
            }
        }
        return this.objectiveManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractSidebar> sidebars() {
        if (this.sidebars == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sidebars == null) {
                    this.sidebars = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
                    this.sidebarTask = new SidebarUpdaterTask(this);
                }
            }
        }
        return this.sidebars;
    }

    @NotNull
    public ScoreboardLibraryPlayer getOrCreatePlayer(@NotNull Player player) {
        return this.playerMap.computeIfAbsent(player, ScoreboardLibraryPlayer::new);
    }

    @Nullable
    public ScoreboardLibraryPlayer getPlayer(@NotNull Player player) {
        return this.playerMap.get(player);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ScoreboardLibrary is closed");
        }
    }
}

