/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.implementation;

import java.lang.reflect.InvocationTargetException;
import me.ulrich.clans.library.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketAdapterLoader {
    private static final String MODERN = "modern";
    private static final String LEGACY = "legacy";
    private static final String PACKET_EVENTS = "packetevents";

    private PacketAdapterLoader() {
    }

    @NotNull
    public static PacketAdapterProvider loadPacketAdapter() {
        Class<?> clazz = PacketAdapterLoader.findAndLoadImplementationClass();
        if (clazz == null) {
            throw new NoPacketAdapterAvailableException();
        }
        try {
            return (PacketAdapterProvider)clazz.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("couldn't initialize packet adapter", reflectiveOperationException);
        }
    }

    @Nullable
    private static Class<?> findAndLoadImplementationClass() {
        Class<?> clazz;
        String string = Bukkit.getServer().getBukkitVersion();
        int n2 = string.indexOf(45);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if ((clazz = PacketAdapterLoader.tryLoadVersion(string)) != null) {
            return clazz;
        }
        return PacketAdapterLoader.tryLoadPacketEvents();
    }

    @Nullable
    private static Class<?> tryLoadVersion(@NotNull String string) {
        switch (string) {
            case "1.7.10": 
            case "1.8": 
            case "1.8.3": 
            case "1.8.4": 
            case "1.8.5": 
            case "1.8.6": 
            case "1.8.7": 
            case "1.8.8": 
            case "1.9": 
            case "1.9.2": 
            case "1.9.4": 
            case "1.10.2": 
            case "1.11": 
            case "1.11.2": 
            case "1.12": 
            case "1.12.1": 
            case "1.12.2": {
                return PacketAdapterLoader.tryLoadImplementationClass(LEGACY);
            }
            case "1.17": 
            case "1.17.1": 
            case "1.18": 
            case "1.18.1": 
            case "1.18.2": 
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": 
            case "1.19.3": 
            case "1.19.4": 
            case "1.20": 
            case "1.20.1": 
            case "1.20.2": 
            case "1.20.3": 
            case "1.20.4": 
            case "1.20.5": 
            case "1.20.6": 
            case "1.21": 
            case "1.21.1": 
            case "1.21.2": 
            case "1.21.3": 
            case "1.21.4": 
            case "1.21.5": 
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": 
            case "1.21.9": 
            case "1.21.10": {
                return PacketAdapterLoader.tryLoadImplementationClass(MODERN);
            }
        }
        String string2 = "net.mega".concat("vex.scoreboardlibrary.forceModern");
        if (System.getProperty(string2, "").equalsIgnoreCase("true")) {
            return PacketAdapterLoader.tryLoadImplementationClass(MODERN);
        }
        return null;
    }

    @Nullable
    private static Class<?> tryLoadPacketEvents() {
        Class<?> clazz = PacketAdapterLoader.tryLoadImplementationClass(PACKET_EVENTS);
        if (clazz == null) {
            return null;
        }
        try {
            Class.forName("me.ulrich.clans.library.packetevents.PacketEvents");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    private static Class<?> tryLoadImplementationClass(@NotNull String string) {
        try {
            String string2 = "me.ulrich.clans.library.scoreboardlibrary.implementation.packetAdapter." + string + ".PacketAdapterProviderImpl";
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

