/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component.animation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component.animation.FramedSidebarAnimation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CollectionSidebarAnimation<T>
implements FramedSidebarAnimation<T> {
    private final List<T> frames;
    private int currentFrameIndex;

    public CollectionSidebarAnimation(@NotNull Collection<T> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        this.frames = ImmutableList.copyOf(collection);
    }

    @Override
    public @Unmodifiable @NotNull List<T> frames() {
        return this.frames;
    }

    @Override
    public int currentFrameIndex() {
        return this.currentFrameIndex;
    }

    @Override
    public void switchFrame(int n2) {
        if (n2 < 0 || n2 >= this.frames.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex = n2;
    }

    @Override
    @NotNull
    public T currentFrame() {
        return this.frames.get(this.currentFrameIndex);
    }

    @Override
    public void nextFrame() {
        if (++this.currentFrameIndex == this.frames.size()) {
            this.currentFrameIndex = 0;
        }
    }
}

