/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component.LineDrawable;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component.animation.SidebarAnimation;
import org.jetbrains.annotations.NotNull;

public interface SidebarComponent {
    @NotNull
    public static SidebarComponent staticLine(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        return lineDrawable -> lineDrawable.drawLine(componentLike);
    }

    @NotNull
    public static SidebarComponent staticLine(@NotNull ComponentLike componentLike, @NotNull ScoreFormat scoreFormat) {
        Preconditions.checkNotNull((Object)componentLike);
        return lineDrawable -> lineDrawable.drawLine(componentLike, scoreFormat);
    }

    @NotNull
    public static SidebarComponent blankLine() {
        return lineDrawable -> lineDrawable.drawLine(Component.empty());
    }

    @NotNull
    public static <T extends ComponentLike> SidebarComponent dynamicLine(@NotNull Supplier<T> supplier) {
        return lineDrawable -> lineDrawable.drawLine((ComponentLike)supplier.get());
    }

    @NotNull
    public static <T extends ComponentLike> SidebarComponent animatedLine(@NotNull SidebarAnimation<T> sidebarAnimation) {
        Preconditions.checkNotNull(sidebarAnimation);
        return lineDrawable -> lineDrawable.drawLine((ComponentLike)sidebarAnimation.currentFrame());
    }

    @NotNull
    public static <T extends SidebarComponent> SidebarComponent animatedComponent(@NotNull SidebarAnimation<T> sidebarAnimation) {
        Preconditions.checkNotNull(sidebarAnimation);
        return lineDrawable -> ((SidebarComponent)sidebarAnimation.currentFrame()).draw(lineDrawable);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public void draw(@NotNull LineDrawable var1);

    public static final class Builder {
        private final List<SidebarComponent> children = new ArrayList<SidebarComponent>(4);

        private Builder() {
        }

        @NotNull
        public Builder addComponent(@NotNull SidebarComponent sidebarComponent) {
            Preconditions.checkNotNull((Object)sidebarComponent);
            this.children.add(sidebarComponent);
            return this;
        }

        @NotNull
        public Builder addStaticLine(@NotNull ComponentLike componentLike) {
            return this.addComponent(SidebarComponent.staticLine(componentLike));
        }

        @NotNull
        public Builder addStaticLine(@NotNull ComponentLike componentLike, @NotNull ScoreFormat scoreFormat) {
            return this.addComponent(SidebarComponent.staticLine(componentLike, scoreFormat));
        }

        @NotNull
        public Builder addBlankLine() {
            return this.addComponent(SidebarComponent.blankLine());
        }

        @NotNull
        public <T extends ComponentLike> Builder addDynamicLine(@NotNull Supplier<T> supplier) {
            return this.addComponent(SidebarComponent.dynamicLine(supplier));
        }

        @NotNull
        public <T extends ComponentLike> Builder addAnimatedLine(@NotNull SidebarAnimation<T> sidebarAnimation) {
            return this.addComponent(SidebarComponent.animatedLine(sidebarAnimation));
        }

        @NotNull
        public <T extends SidebarComponent> Builder addAnimatedComponent(@NotNull SidebarAnimation<T> sidebarAnimation) {
            return this.addComponent(SidebarComponent.animatedComponent(sidebarAnimation));
        }

        @NotNull
        public SidebarComponent build() {
            ImmutableList immutableList = ImmutableList.copyOf(this.children);
            return lineDrawable -> {
                for (SidebarComponent sidebarComponent : immutableList) {
                    sidebarComponent.draw(lineDrawable);
                }
            };
        }
    }
}

