/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component;

import com.google.common.base.Preconditions;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.Sidebar;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component.LineDrawable;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.component.SidebarComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentSidebarLayout {
    private final SidebarComponent titleComponent;
    private final SidebarComponent linesComponent;

    public ComponentSidebarLayout(@NotNull SidebarComponent sidebarComponent, @NotNull SidebarComponent sidebarComponent2) {
        Preconditions.checkNotNull((Object)sidebarComponent);
        Preconditions.checkNotNull((Object)sidebarComponent2);
        this.titleComponent = sidebarComponent;
        this.linesComponent = sidebarComponent2;
    }

    @NotNull
    public SidebarComponent titleComponent() {
        return this.titleComponent;
    }

    @NotNull
    public SidebarComponent linesComponent() {
        return this.linesComponent;
    }

    public void apply(@NotNull Sidebar sidebar) {
        Preconditions.checkNotNull((Object)sidebar);
        SidebarTitleDrawable sidebarTitleDrawable = new SidebarTitleDrawable();
        this.titleComponent.draw(sidebarTitleDrawable);
        sidebar.title(sidebarTitleDrawable.title == null ? Component.empty() : sidebarTitleDrawable.title);
        SidebarLineDrawable sidebarLineDrawable = new SidebarLineDrawable(sidebar);
        this.linesComponent.draw(sidebarLineDrawable);
        for (int i2 = sidebarLineDrawable.index; i2 < 15; ++i2) {
            sidebar.line(i2, null);
        }
    }

    private static class SidebarTitleDrawable
    implements LineDrawable {
        private Component title;

        private SidebarTitleDrawable() {
        }

        @Override
        public void drawLine(@NotNull ComponentLike componentLike, @Nullable ScoreFormat scoreFormat) {
            Preconditions.checkNotNull((Object)componentLike);
            if (this.title == null) {
                this.title = componentLike.asComponent();
            }
        }
    }

    private static class SidebarLineDrawable
    implements LineDrawable {
        private final Sidebar sidebar;
        private int index = 0;

        public SidebarLineDrawable(@NotNull Sidebar sidebar) {
            this.sidebar = sidebar;
        }

        @Override
        public void drawLine(@NotNull ComponentLike componentLike, @Nullable ScoreFormat scoreFormat) {
            Preconditions.checkNotNull((Object)componentLike);
            if (this.index < this.sidebar.maxLines()) {
                this.sidebar.line(this.index++, componentLike, scoreFormat);
            }
        }
    }
}

