/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.objective;

import com.google.common.base.Preconditions;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.format.StyleBuilderApplicable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface ScoreFormat {
    @NotNull
    public static Blank blank() {
        return Blank.INSTANCE;
    }

    @NotNull
    public static Fixed fixed(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        return new Fixed(componentLike.asComponent());
    }

    @NotNull
    public static Styled styled(@NotNull Style style) {
        Preconditions.checkNotNull((Object)style);
        return new Styled(style);
    }

    @NotNull
    public static Styled styled(StyleBuilderApplicable ... styleBuilderApplicableArray) {
        Preconditions.checkNotNull((Object)styleBuilderApplicableArray);
        return new Styled(Style.style(styleBuilderApplicableArray));
    }

    public static class Blank
    implements ScoreFormat {
        private static final Blank INSTANCE = new Blank();

        private Blank() {
        }

        public String toString() {
            return "Blank";
        }
    }

    public static class Fixed
    implements ScoreFormat {
        private final Component content;

        public Fixed(@NotNull Component component) {
            this.content = component;
        }

        @NotNull
        public Component content() {
            return this.content;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Fixed fixed = (Fixed)object;
            return this.content.equals(fixed.content);
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public String toString() {
            return "Fixed{content=" + this.content + "}";
        }
    }

    public static class Styled
    implements ScoreFormat {
        private final Style style;

        public Styled(@NotNull Style style) {
            this.style = style;
        }

        @NotNull
        public Style style() {
            return this.style;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Styled styled = (Styled)object;
            return this.style.equals(styled.style);
        }

        public int hashCode() {
            return this.style.hashCode();
        }

        public String toString() {
            return "Styled{style=" + this.style + "}";
        }
    }
}

