/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.objective;

import com.google.common.base.Preconditions;
import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface ObjectiveDisplaySlot {
    @NotNull
    public static PlayerList playerList() {
        return PlayerList.INSTANCE;
    }

    @NotNull
    public static Sidebar sidebar() {
        return Sidebar.INSTANCE;
    }

    @NotNull
    public static BelowName belowName() {
        return BelowName.INSTANCE;
    }

    @NotNull
    public static TeamSidebar teamSidebar(@NotNull NamedTextColor namedTextColor) {
        Preconditions.checkNotNull((Object)namedTextColor);
        return new TeamSidebar(namedTextColor);
    }

    public static class PlayerList
    implements ObjectiveDisplaySlot {
        private static final PlayerList INSTANCE = new PlayerList();

        private PlayerList() {
        }

        public String toString() {
            return "PlayerList";
        }
    }

    public static class Sidebar
    implements ObjectiveDisplaySlot {
        private static final Sidebar INSTANCE = new Sidebar();

        private Sidebar() {
        }

        public String toString() {
            return "Sidebar";
        }
    }

    public static class BelowName
    implements ObjectiveDisplaySlot {
        private static final BelowName INSTANCE = new BelowName();

        private BelowName() {
        }

        public String toString() {
            return "BelowName";
        }
    }

    public static class TeamSidebar
    implements ObjectiveDisplaySlot {
        private final NamedTextColor teamColor;

        private TeamSidebar(@NotNull NamedTextColor namedTextColor) {
            this.teamColor = namedTextColor;
        }

        @NotNull
        public NamedTextColor teamColor() {
            return this.teamColor;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TeamSidebar teamSidebar = (TeamSidebar)object;
            return this.teamColor.equals(teamSidebar.teamColor);
        }

        public int hashCode() {
            return this.teamColor.hashCode();
        }

        public String toString() {
            return "TeamSidebar{teamColor=" + this.teamColor + "}";
        }
    }
}

