/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.noop;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.ulrich.clans.library.scoreboardlibrary.api.noop.NoopScoreboardTeam;
import me.ulrich.clans.library.scoreboardlibrary.api.noop.NoopTeamDisplay;
import me.ulrich.clans.library.scoreboardlibrary.api.team.ScoreboardTeam;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamDisplay;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NoopTeamManager
implements TeamManager {
    private final Set<Player> players = new HashSet<Player>();
    private final Map<String, NoopScoreboardTeam> teams = new HashMap<String, NoopScoreboardTeam>();
    private boolean closed;

    NoopTeamManager() {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.remove(player)) {
            return false;
        }
        for (NoopScoreboardTeam noopScoreboardTeam : this.teams.values()) {
            noopScoreboardTeam.displayMap().remove(player);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<ScoreboardTeam> teams() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableCollection(this.teams.values());
    }

    @Override
    @Nullable
    public ScoreboardTeam team(@NotNull String string) {
        return this.teams.get(string.toLowerCase());
    }

    @Override
    public boolean teamExists(@NotNull String string) {
        return this.teams.containsKey(string.toLowerCase());
    }

    @Override
    @NotNull
    public ScoreboardTeam createIfAbsent(@NotNull String string, @Nullable BiFunction<Player, ScoreboardTeam, TeamDisplay> biFunction) {
        Preconditions.checkNotNull((Object)string);
        this.checkClosed();
        string = string.toLowerCase();
        NoopScoreboardTeam noopScoreboardTeam = this.teams.get(string);
        if (noopScoreboardTeam != null) {
            return noopScoreboardTeam;
        }
        noopScoreboardTeam = new NoopScoreboardTeam(this, string);
        for (Player player : this.players) {
            NoopTeamDisplay noopTeamDisplay = biFunction == null ? noopScoreboardTeam.defaultDisplay() : biFunction.apply(player, noopScoreboardTeam);
            this.validateTeamDisplay(noopScoreboardTeam, noopTeamDisplay);
            noopScoreboardTeam.displayMap().put(player, noopTeamDisplay);
        }
        return noopScoreboardTeam;
    }

    @Override
    public boolean removeTeam(@NotNull String string) {
        Preconditions.checkNotNull((Object)string);
        this.checkClosed();
        return this.teams.remove(string.toLowerCase()) != null;
    }

    @Override
    public void removeTeam(@NotNull ScoreboardTeam scoreboardTeam) {
        Preconditions.checkNotNull((Object)scoreboardTeam);
        Preconditions.checkArgument((scoreboardTeam.teamManager() == this ? 1 : 0) != 0);
        this.checkClosed();
        this.teams.remove(scoreboardTeam.name(), (NoopScoreboardTeam)scoreboardTeam);
    }

    @Override
    public boolean addPlayer(@NotNull Player player, @Nullable Function<ScoreboardTeam, TeamDisplay> function) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.add(player)) {
            return false;
        }
        for (NoopScoreboardTeam noopScoreboardTeam : this.teams.values()) {
            NoopTeamDisplay noopTeamDisplay = function == null ? noopScoreboardTeam.defaultDisplay() : function.apply(noopScoreboardTeam);
            this.validateTeamDisplay(noopScoreboardTeam, noopTeamDisplay);
            noopScoreboardTeam.displayMap().put(player, noopTeamDisplay);
        }
        return true;
    }

    private void validateTeamDisplay(@NotNull ScoreboardTeam scoreboardTeam, @Nullable TeamDisplay teamDisplay) {
        if (teamDisplay == null || teamDisplay.team() != scoreboardTeam) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        if (!(teamDisplay instanceof NoopTeamDisplay)) {
            throw new IllegalArgumentException("must be TeamDisplayImpl");
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopTeamManager is closed");
        }
    }
}

