/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.noop;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ScoreFormat;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.Sidebar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

class NoopSidebar
implements Sidebar {
    private final Set<Player> players = new HashSet<Player>();
    private final int maxLines;
    private final String objectiveName;
    private final Locale locale;
    private final Component[] lines;
    private Component title = Component.empty();
    private boolean closed;

    NoopSidebar(int n2, String string, @Nullable Locale locale) {
        this.maxLines = n2;
        this.locale = locale;
        this.objectiveName = string;
        this.lines = new Component[n2];
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        return this.players.add(player);
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        return this.players.remove(player);
    }

    @Override
    public @Range(from=1L, to=15L) int maxLines() {
        return this.maxLines;
    }

    @Override
    @NotNull
    public String objectiveName() {
        return this.objectiveName;
    }

    @Override
    @Nullable
    public Locale locale() {
        return this.locale;
    }

    @Override
    public void line(int n2, @Nullable ComponentLike componentLike, @Nullable ScoreFormat scoreFormat) {
        this.checkLineBounds(n2);
        this.checkClosed();
        this.lines[n2] = componentLike == null ? null : componentLike.asComponent();
    }

    @Override
    public void refreshLine(@Range(from=0L, to=0x7FFFFFFEL) int n2) {
    }

    @Override
    @Nullable
    public Component line(int n2) {
        this.checkLineBounds(n2);
        this.checkClosed();
        return this.lines[n2];
    }

    @Override
    @NotNull
    public Component title() {
        return this.title;
    }

    @Override
    public void title(@NotNull ComponentLike componentLike) {
        Preconditions.checkNotNull((Object)componentLike);
        this.checkClosed();
        this.title = componentLike.asComponent();
    }

    @Override
    public void refreshTitle() {
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopSidebar is closed");
        }
    }

    private void checkLineBounds(int n2) {
        if (n2 >= this.maxLines || n2 < 0) {
            throw new IndexOutOfBoundsException("invalid line " + n2);
        }
    }
}

