/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api.noop;

import java.util.Locale;
import me.ulrich.clans.library.scoreboardlibrary.api.ScoreboardLibrary;
import me.ulrich.clans.library.scoreboardlibrary.api.noop.NoopObjectiveManager;
import me.ulrich.clans.library.scoreboardlibrary.api.noop.NoopSidebar;
import me.ulrich.clans.library.scoreboardlibrary.api.noop.NoopTeamManager;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveManager;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.Sidebar;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class NoopScoreboardLibrary
implements ScoreboardLibrary {
    private boolean closed = false;

    @Override
    @NotNull
    public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int n2, @Nullable Locale locale, @NotNull String string) {
        this.checkClosed();
        return new NoopSidebar(n2, string, locale);
    }

    @Override
    @NotNull
    public TeamManager createTeamManager() {
        this.checkClosed();
        return new NoopTeamManager();
    }

    @Override
    @NotNull
    public ObjectiveManager createObjectiveManager() {
        this.checkClosed();
        return new NoopObjectiveManager();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopScoreboardLibrary is closed");
        }
    }
}

