/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.scoreboardlibrary.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import me.ulrich.clans.library.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import me.ulrich.clans.library.scoreboardlibrary.api.objective.ObjectiveManager;
import me.ulrich.clans.library.scoreboardlibrary.api.sidebar.Sidebar;
import me.ulrich.clans.library.scoreboardlibrary.api.team.TeamManager;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.NonExtendable
public interface ScoreboardLibrary {
    @NotNull
    public static ScoreboardLibrary loadScoreboardLibrary(@NotNull Plugin plugin) {
        Class<?> clazz;
        try {
            clazz = Class.forName("me.ulrich.clans.library.scoreboardlibrary.implementation.ScoreboardLibraryImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("scoreboard-library implementation is not shaded into the classpath");
        }
        try {
            return (ScoreboardLibrary)clazz.getDeclaredConstructor(Plugin.class).newInstance(plugin);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwable throwable;
            if (reflectiveOperationException instanceof InvocationTargetException && (throwable = ((InvocationTargetException)reflectiveOperationException).getTargetException()) instanceof NoPacketAdapterAvailableException) {
                throw (NoPacketAdapterAvailableException)throwable;
            }
            throw new RuntimeException("failed to load scoreboard-library implementation", reflectiveOperationException);
        }
    }

    @NotNull
    default public Sidebar createSidebar() {
        return this.createSidebar(15);
    }

    @NotNull
    default public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int n2) {
        return this.createSidebar(n2, null);
    }

    @NotNull
    default public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int n2, @Nullable Locale locale) {
        return this.createSidebar(n2, locale, RandomStringUtils.randomAlphanumeric((int)16));
    }

    @NotNull
    public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int var1, @Nullable Locale var2, @NotNull String var3);

    @NotNull
    public TeamManager createTeamManager();

    @NotNull
    public ObjectiveManager createObjectiveManager();

    public void close();

    public boolean closed();
}

