/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class SafeEncoder {
    public static volatile Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private SafeEncoder() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static byte[][] encodeMany(String ... stringArray) {
        byte[][] byArrayArray = new byte[stringArray.length][];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            byArrayArray[i2] = SafeEncoder.encode(stringArray[i2]);
        }
        return byArrayArray;
    }

    public static byte[] encode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null value cannot be sent to redis");
        }
        return string.getBytes(DEFAULT_CHARSET);
    }

    public static String encode(byte[] byArray) {
        return new String(byArray, DEFAULT_CHARSET);
    }

    public static Object encodeObject(Object object) {
        if (object instanceof byte[]) {
            return SafeEncoder.encode((byte[])object);
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (Object e2 : list) {
                arrayList.add(SafeEncoder.encodeObject(e2));
            }
            return arrayList;
        }
        return object;
    }
}

