/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.io.FilterOutputStream;
import java.io.OutputStream;

public final class RedisOutputStream
extends FilterOutputStream {
    private static final int OUTPUT_BUFFER_SIZE = Integer.parseInt(System.getProperty("jedis.bufferSize.output", System.getProperty("jedis.bufferSize", "8192")));
    protected final byte[] buf;
    protected int count;
    private static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

    public RedisOutputStream(OutputStream outputStream) {
        this(outputStream, OUTPUT_BUFFER_SIZE);
    }

    public RedisOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n2];
    }

    private void flushBuffer() {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(byte by) {
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = by;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 >= this.buf.length) {
            this.flushBuffer();
            this.out.write(byArray, n2, n3);
        } else {
            if (n3 >= this.buf.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(byArray, n2, this.buf, this.count, n3);
            this.count += n3;
        }
    }

    public void writeCrLf() {
        if (2 >= this.buf.length - this.count) {
            this.flushBuffer();
        }
        this.buf[this.count++] = 13;
        this.buf[this.count++] = 10;
    }

    public void writeIntCrLf(int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            this.write((byte)45);
            n2 = -n2;
        }
        int n5 = 0;
        while (n2 > sizeTable[n5]) {
            ++n5;
        }
        if (++n5 >= this.buf.length - this.count) {
            this.flushBuffer();
        }
        int n6 = this.count + n5;
        while (n2 >= 65536) {
            n4 = n2 / 100;
            n3 = n2 - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n2 = n4;
            this.buf[--n6] = DigitOnes[n3];
            this.buf[--n6] = DigitTens[n3];
        }
        do {
            n4 = n2 * 52429 >>> 19;
            n3 = n2 - ((n4 << 3) + (n4 << 1));
            this.buf[--n6] = digits[n3];
        } while ((n2 = n4) != 0);
        this.count += n5;
        this.writeCrLf();
    }

    @Override
    public void flush() {
        this.flushBuffer();
        this.out.flush();
    }
}

