/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;

public class RedisInputStream
extends FilterInputStream {
    private static final int INPUT_BUFFER_SIZE = Integer.parseInt(System.getProperty("jedis.bufferSize.input", System.getProperty("jedis.bufferSize", "8192")));
    protected final byte[] buf;
    protected int count;
    protected int limit;

    public RedisInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n2];
    }

    public RedisInputStream(InputStream inputStream) {
        this(inputStream, INPUT_BUFFER_SIZE);
    }

    public byte readByte() {
        this.ensureFill();
        return this.buf[this.count++];
    }

    public String readLine() {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            this.ensureFill();
            byte by = this.buf[this.count++];
            if (by == 13) {
                this.ensureFill();
                byte by2 = this.buf[this.count++];
                if (by2 == 10) break;
                stringBuilder.append((char)by);
                stringBuilder.append((char)by2);
                continue;
            }
            stringBuilder.append((char)by);
        }
        String string = stringBuilder.toString();
        if (string.length() == 0) {
            throw new JedisConnectionException("It seems like server has closed the connection.");
        }
        return string;
    }

    public byte[] readLineBytes() {
        this.ensureFill();
        int n2 = this.count;
        byte[] byArray = this.buf;
        while (true) {
            if (n2 == this.limit) {
                return this.readLineBytesSlowly();
            }
            if (byArray[n2++] != 13) continue;
            if (n2 == this.limit) {
                return this.readLineBytesSlowly();
            }
            if (byArray[n2++] == 10) break;
        }
        int n3 = n2 - this.count - 2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, this.count, byArray2, 0, n3);
        this.count = n2;
        return byArray2;
    }

    private byte[] readLineBytesSlowly() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        while (true) {
            this.ensureFill();
            byte by = this.buf[this.count++];
            if (by == 13) {
                this.ensureFill();
                byte by2 = this.buf[this.count++];
                if (by2 == 10) break;
                if (byteArrayOutputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream(16);
                }
                byteArrayOutputStream.write(by);
                byteArrayOutputStream.write(by2);
                continue;
            }
            if (byteArrayOutputStream == null) {
                byteArrayOutputStream = new ByteArrayOutputStream(16);
            }
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream == null ? new byte[]{} : byteArrayOutputStream.toByteArray();
    }

    public int readIntCrLf() {
        return (int)this.readLongCrLf();
    }

    public long readLongCrLf() {
        boolean bl;
        byte[] byArray = this.buf;
        this.ensureFill();
        boolean bl2 = bl = byArray[this.count] == 45;
        if (bl) {
            ++this.count;
        }
        long l2 = 0L;
        while (true) {
            this.ensureFill();
            byte by = byArray[this.count++];
            if (by == 13) {
                this.ensureFill();
                if (byArray[this.count++] == 10) break;
                throw new JedisConnectionException("Unexpected character!");
            }
            l2 = l2 * 10L + (long)by - 48L;
        }
        return bl ? -l2 : l2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        this.ensureFill();
        int n4 = Math.min(this.limit - this.count, n3);
        System.arraycopy(this.buf, this.count, byArray, n2, n4);
        this.count += n4;
        return n4;
    }

    private void ensureFill() {
        if (this.count >= this.limit) {
            try {
                this.limit = this.in.read(this.buf);
                this.count = 0;
                if (this.limit == -1) {
                    throw new JedisConnectionException("Unexpected end of stream.");
                }
            }
            catch (IOException iOException) {
                throw new JedisConnectionException(iOException);
            }
        }
    }
}

