/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class Pool<T>
extends GenericObjectPool<T> {
    public Pool(GenericObjectPoolConfig<T> genericObjectPoolConfig, PooledObjectFactory<T> pooledObjectFactory) {
        this(pooledObjectFactory, genericObjectPoolConfig);
    }

    public Pool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig<T> genericObjectPoolConfig) {
        super(pooledObjectFactory, genericObjectPoolConfig);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        try {
            super.close();
        }
        catch (RuntimeException runtimeException) {
            throw new JedisException("Could not destroy the pool", runtimeException);
        }
    }

    public T getResource() {
        try {
            return super.borrowObject();
        }
        catch (JedisException jedisException) {
            throw jedisException;
        }
        catch (Exception exception) {
            throw new JedisException("Could not get a resource from the pool", exception);
        }
    }

    public void returnResource(T t2) {
        if (t2 == null) {
            return;
        }
        try {
            super.returnObject(t2);
        }
        catch (RuntimeException runtimeException) {
            throw new JedisException("Could not return the resource to the pool", runtimeException);
        }
    }

    public void returnBrokenResource(T t2) {
        if (t2 == null) {
            return;
        }
        try {
            super.invalidateObject(t2);
        }
        catch (Exception exception) {
            throw new JedisException("Could not return the broken resource to the pool", exception);
        }
    }

    @Override
    public void addObjects(int n2) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addObject();
            }
        }
        catch (Exception exception) {
            throw new JedisException("Error trying to add idle objects", exception);
        }
    }
}

