/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import me.ulrich.clans.library.redis.jedis.util.Hashing;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class MurmurHash
implements Hashing {
    public static int hash(byte[] byArray, int n2) {
        return MurmurHash.hash(ByteBuffer.wrap(byArray), n2);
    }

    public static int hash(byte[] byArray, int n2, int n3, int n4) {
        return MurmurHash.hash(ByteBuffer.wrap(byArray, n2, n3), n4);
    }

    public static int hash(ByteBuffer byteBuffer, int n2) {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n3 = 1540483477;
        int n4 = 24;
        int n5 = n2 ^ byteBuffer.remaining();
        while (byteBuffer.remaining() >= 4) {
            int n6 = byteBuffer.getInt();
            n6 *= n3;
            n6 ^= n6 >>> n4;
            n5 *= n3;
            n5 ^= (n6 *= n3);
        }
        if (byteBuffer.remaining() > 0) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.put(byteBuffer).rewind();
            n5 ^= byteBuffer2.getInt();
            n5 *= n3;
        }
        n5 ^= n5 >>> 13;
        n5 *= n3;
        n5 ^= n5 >>> 15;
        byteBuffer.order(byteOrder);
        return n5;
    }

    public static long hash64A(byte[] byArray, int n2) {
        return MurmurHash.hash64A(ByteBuffer.wrap(byArray), n2);
    }

    public static long hash64A(byte[] byArray, int n2, int n3, int n4) {
        return MurmurHash.hash64A(ByteBuffer.wrap(byArray, n2, n3), n4);
    }

    public static long hash64A(ByteBuffer byteBuffer, int n2) {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l2 = -4132994306676758123L;
        int n3 = 47;
        long l3 = (long)n2 ^ (long)byteBuffer.remaining() * l2;
        while (byteBuffer.remaining() >= 8) {
            long l4 = byteBuffer.getLong();
            l4 *= l2;
            l4 ^= l4 >>> n3;
            l3 ^= (l4 *= l2);
            l3 *= l2;
        }
        if (byteBuffer.remaining() > 0) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer2.put(byteBuffer).rewind();
            l3 ^= byteBuffer2.getLong();
            l3 *= l2;
        }
        l3 ^= l3 >>> n3;
        l3 *= l2;
        l3 ^= l3 >>> n3;
        byteBuffer.order(byteOrder);
        return l3;
    }

    @Override
    public long hash(byte[] byArray) {
        return MurmurHash.hash64A(byArray, 305441741);
    }

    @Override
    public long hash(String string) {
        return this.hash(SafeEncoder.encode(string));
    }
}

