/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.net.URI;
import me.ulrich.clans.library.redis.jedis.HostAndPort;

public final class JedisURIHelper {
    private static final int DEFAULT_DB = 0;
    private static final String REDIS = "redis";
    private static final String REDISS = "rediss";

    private JedisURIHelper() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static HostAndPort getHostAndPort(URI uRI) {
        return new HostAndPort(uRI.getHost(), uRI.getPort());
    }

    public static String getUser(URI uRI) {
        String string = uRI.getUserInfo();
        if (string != null) {
            String string2 = string.split(":", 2)[0];
            if (string2.isEmpty()) {
                string2 = null;
            }
            return string2;
        }
        return null;
    }

    public static String getPassword(URI uRI) {
        String string = uRI.getUserInfo();
        if (string != null) {
            return string.split(":", 2)[1];
        }
        return null;
    }

    public static int getDBIndex(URI uRI) {
        String[] stringArray = uRI.getPath().split("/", 2);
        if (stringArray.length > 1) {
            String string = stringArray[1];
            if (string.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(string);
        }
        return 0;
    }

    public static boolean isValid(URI uRI) {
        return !JedisURIHelper.isEmpty(uRI.getScheme()) && !JedisURIHelper.isEmpty(uRI.getHost()) && uRI.getPort() != -1;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isRedisScheme(URI uRI) {
        return REDIS.equals(uRI.getScheme());
    }

    public static boolean isRedisSSLScheme(URI uRI) {
        return REDISS.equals(uRI.getScheme());
    }
}

