/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JedisByteHashMap
implements Serializable,
Cloneable,
Map<byte[], byte[]> {
    private static final long serialVersionUID = -6971431362627219416L;
    private final Map<ByteArrayWrapper, byte[]> internalMap = new HashMap<ByteArrayWrapper, byte[]>();

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof byte[]) {
            return this.internalMap.containsKey(new ByteArrayWrapper((byte[])object));
        }
        return this.internalMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.internalMap.containsValue(object);
    }

    @Override
    public Set<Map.Entry<byte[], byte[]>> entrySet() {
        Iterator<Map.Entry<ByteArrayWrapper, byte[]>> iterator = this.internalMap.entrySet().iterator();
        HashSet<Map.Entry<byte[], byte[]>> hashSet = new HashSet<Map.Entry<byte[], byte[]>>();
        while (iterator.hasNext()) {
            Map.Entry<ByteArrayWrapper, byte[]> entry = iterator.next();
            hashSet.add(new JedisByteEntry(entry.getKey().data, entry.getValue()));
        }
        return hashSet;
    }

    @Override
    public byte[] get(Object object) {
        if (object instanceof byte[]) {
            return this.internalMap.get(new ByteArrayWrapper((byte[])object));
        }
        return this.internalMap.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public Set<byte[]> keySet() {
        HashSet<byte[]> hashSet = new HashSet<byte[]>();
        Iterator<ByteArrayWrapper> iterator = this.internalMap.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().data);
        }
        return hashSet;
    }

    @Override
    public byte[] put(byte[] byArray, byte[] byArray2) {
        return this.internalMap.put(new ByteArrayWrapper(byArray), byArray2);
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends byte[]> map) {
        for (Map.Entry<? extends byte[], ? extends byte[]> entry : map.entrySet()) {
            this.internalMap.put(new ByteArrayWrapper(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public byte[] remove(Object object) {
        if (object instanceof byte[]) {
            return this.internalMap.remove(new ByteArrayWrapper((byte[])object));
        }
        return this.internalMap.remove(object);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public Collection<byte[]> values() {
        return this.internalMap.values();
    }

    private static final class JedisByteEntry
    implements Map.Entry<byte[], byte[]> {
        private byte[] value;
        private byte[] key;

        public JedisByteEntry(byte[] byArray, byte[] byArray2) {
            this.key = byArray;
            this.value = byArray2;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] setValue(byte[] byArray) {
            this.value = byArray;
            return byArray;
        }
    }

    private static final class ByteArrayWrapper
    implements Serializable {
        private final byte[] data;

        public ByteArrayWrapper(byte[] byArray) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.data = byArray;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.data, ((ByteArrayWrapper)object).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

